/*
 * Decompiled with CFR 0.152.
 */
package org.andwellness.xml.datagenerator;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import org.andwellness.xml.datagenerator.creator.DataPointCreator;
import org.andwellness.xml.datagenerator.creator.DataPointCreatorFactory;
import org.andwellness.xml.datagenerator.custom.DataPointConditionEvaluator;
import org.andwellness.xml.datagenerator.model.DataPoint;
import org.andwellness.xml.datagenerator.model.RepeatableSet;
import org.andwellness.xml.datagenerator.model.Survey;
import org.andwellness.xml.datagenerator.utility.ValueCreator;
import org.apache.log4j.Logger;

public class SurveyCreator {
    List<DataPoint> dataPointList = new ArrayList<DataPoint>();
    Map<String, Object> surveyMetadata = new HashMap<String, Object>();
    private static Logger _logger = Logger.getLogger(SurveyCreator.class);

    public Survey createSurvey(Node surveyNode, Date creationTime) {
        String surveyNodeType = ((Element)surveyNode).getLocalName();
        if (!surveyNodeType.equals("survey")) {
            throw new IllegalArgumentException("The passed Node is not a survey node.");
        }
        String surveyId = surveyNode.query("id").get(0).getValue();
        String surveyTitle = surveyNode.query("title").get(0).getValue();
        _logger.debug("Creating survey " + surveyId + " at time " + creationTime);
        Survey createdSurvey = new Survey();
        createdSurvey.setId(surveyId);
        createdSurvey.setTitle(surveyTitle);
        createdSurvey.setCreationTime(creationTime);
        createdSurvey.setLat(ValueCreator.latitude());
        createdSurvey.setLon(ValueCreator.longitude());
        createdSurvey.setTz(ValueCreator.tz());
        createdSurvey.setLaunchTime(creationTime);
        Nodes contentList = surveyNode.query("contentList");
        int numberOfItemsInContentList = contentList.size();
        for (int x = 0; x < numberOfItemsInContentList; ++x) {
            Nodes promptsOrRepeatableSets = contentList.get(x).query("prompt | repeatableSet");
            int numberOfPromptsOrRepeatableSets = promptsOrRepeatableSets.size();
            for (int promptIndex = 0; promptIndex < numberOfPromptsOrRepeatableSets; ++promptIndex) {
                Node currentNode = promptsOrRepeatableSets.get(promptIndex);
                String currentNodeId = currentNode.query("id").get(0).getValue();
                String currentNodeType = ((Element)currentNode).getLocalName();
                Nodes currentNodeConditions = currentNode.query("condition");
                String currentNodeCondition = "";
                if (currentNodeConditions.size() > 0) {
                    currentNodeCondition = currentNodeConditions.get(0).getValue();
                }
                if ("prompt".equals(currentNodeType)) {
                    DataPoint dataPoint;
                    block12: {
                        _logger.debug("found a prompt with id " + currentNodeId);
                        if (DataPointConditionEvaluator.evaluateCondition(currentNodeCondition, this.dataPointList)) {
                            try {
                                dataPoint = this.generatePrompt(currentNode);
                                break block12;
                            }
                            catch (IllegalArgumentException e) {
                                _logger.warn(e.getMessage());
                                continue;
                            }
                        }
                        dataPoint = this.generateNotDisplayedPrompt(currentNode);
                    }
                    this.dataPointList.add(dataPoint);
                    createdSurvey.addResponse(dataPoint);
                    continue;
                }
                if ("repeatableSet".equals(currentNodeType)) {
                    _logger.debug("found a repeatableSet with id " + currentNodeId);
                    RepeatableSet generatedRepeatableSet = new RepeatableSet();
                    generatedRepeatableSet.setId(currentNodeId);
                    if (DataPointConditionEvaluator.evaluateCondition(currentNodeCondition, createdSurvey.getCurrentDataPoints())) {
                        do {
                            List<DataPoint> repeatableSetDataPointList = this.generateRepeatableSet(currentNode);
                            generatedRepeatableSet.addSet(repeatableSetDataPointList);
                        } while (ValueCreator.randomBoolean());
                    } else {
                        generatedRepeatableSet.setNotDisplayed();
                    }
                    createdSurvey.addResponse(generatedRepeatableSet);
                    continue;
                }
                _logger.error("Found a bad XML node in the contentList with id " + currentNodeId + " and type " + currentNodeType);
            }
        }
        return createdSurvey;
    }

    private List<DataPoint> generateRepeatableSet(Node currentNode) {
        String currentNodeId = currentNode.query("id").get(0).getValue();
        String currentNodeType = ((Element)currentNode).getLocalName();
        ArrayList<DataPoint> promptDataPointList = new ArrayList<DataPoint>();
        if (!"repeatableSet".equals(currentNodeType)) {
            throw new IllegalArgumentException("Need a repeatableSet, instead found a node of type " + currentNodeType + " with id " + currentNodeId);
        }
        Nodes repeatableSetPromptNodes = currentNode.query("prompts/prompt");
        int numberOfInnerElements = repeatableSetPromptNodes.size();
        for (int i = 0; i < numberOfInnerElements; ++i) {
            Node currentInnerNode = repeatableSetPromptNodes.get(i);
            String currentInnerId = currentInnerNode.query("id").get(0).getValue();
            String currentInnerType = ((Element)currentInnerNode).getLocalName();
            Nodes currentInnerConditions = currentInnerNode.query("condition");
            String currentInnerCondition = "";
            if (currentInnerConditions.size() > 0) {
                currentInnerCondition = currentInnerConditions.get(0).getValue();
            }
            if ("prompt".equals(currentInnerType)) {
                DataPoint promptDataPoint;
                block7: {
                    _logger.debug("found a prompt with id " + currentInnerId);
                    if (DataPointConditionEvaluator.evaluateCondition(currentInnerCondition, promptDataPointList)) {
                        try {
                            promptDataPoint = this.generatePrompt(currentInnerNode);
                            break block7;
                        }
                        catch (IllegalArgumentException e) {
                            _logger.warn(e.getMessage());
                            continue;
                        }
                    }
                    promptDataPoint = this.generateNotDisplayedPrompt(currentInnerNode);
                }
                promptDataPointList.add(promptDataPoint);
                continue;
            }
            _logger.error("Found a bad XML node in the repeatableSet with id " + currentInnerId + " and type " + currentInnerType);
        }
        return promptDataPointList;
    }

    private DataPoint generatePrompt(Node currentNode) {
        String promptType = currentNode.query("promptType").get(0).getValue();
        DataPointCreator dataPointCreator = DataPointCreatorFactory.getDataPointCreator(promptType);
        DataPoint createdDataPoint = dataPointCreator.create(currentNode);
        return createdDataPoint;
    }

    private DataPoint generateNotDisplayedPrompt(Node currentNode) {
        String displayType = currentNode.query("displayType").get(0).getValue();
        String nodeId = currentNode.query("id").get(0).getValue();
        String promptType = currentNode.query("promptType").get(0).getValue();
        DataPoint createdDataPoint = new DataPoint();
        createdDataPoint.setId(nodeId);
        createdDataPoint.setPromptType(promptType);
        createdDataPoint.setDisplayType(displayType);
        createdDataPoint.setNotDisplayed();
        return createdDataPoint;
    }
}

