% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CharacterizationPlots.R
\name{plotSexDistributions}
\alias{plotSexDistributions}
\title{Plots the sex distributions using the sex features}
\usage{
plotSexDistributions(
  sexData,
  riskWindowStart = "1",
  riskWindowEnd = "365",
  startAnchor = "cohort start",
  endAnchor = "cohort start"
)
}
\arguments{
\item{sexData}{The sex data extracted using 'getCharacterizationDemographics(type = 'sex')'}

\item{riskWindowStart}{The time at risk window start}

\item{riskWindowEnd}{The time at risk window end}

\item{startAnchor}{The anchor for the time at risk start}

\item{endAnchor}{The anchor for the time at risk end}
}
\value{
Returns a ggplot with the distributions
}
\description{
Creates bar charts for the target and case sex.
}
\details{
Input the data returned from 'getCharacterizationDemographics(type = 'sex')' and the time-at-risk
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

sexData <- getCharacterizationDemographics(
  connectionHandler = connectionHandler, 
  schema = 'main',
  targetId = 1, 
  outcomeId = 3, 
  type = 'sex'
)
plotSexDistributions(sexData = sexData)

}
\seealso{
Other Characterization: 
\code{\link{getBinaryCaseSeries}()},
\code{\link{getBinaryRiskFactors}()},
\code{\link{getCaseBinaryFeatures}()},
\code{\link{getCaseContinuousFeatures}()},
\code{\link{getCaseCounts}()},
\code{\link{getCharacterizationDemographics}()},
\code{\link{getContinuousCaseSeries}()},
\code{\link{getContinuousRiskFactors}()},
\code{\link{getDechallengeRechallenge}()},
\code{\link{getIncidenceRates}()},
\code{\link{getTargetBinaryFeatures}()},
\code{\link{getTargetContinuousFeatures}()},
\code{\link{getTargetCounts}()},
\code{\link{getTimeToEvent}()},
\code{\link{plotAgeDistributions}()}
}
\concept{Characterization}
