% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{Eta2}
\alias{Eta2}
\title{A function to compute adjusted isolation index (Eta2)}
\usage{
Eta2(x)
}
\arguments{
\item{x}{- an object of class matrix (or that can be coerced
to that class), where each column represents the distribution
of a population group, within spatial units. The number of
columns should be greater than one (at least two population
groups are required).}
}
\value{
A vector with adjusted isolation index
}
\description{
Adjusted isolation index (also known as Eta2 or
the Correlation Ratio index) adapts isolation index \code{
\link{xPx}} by taking into account the differences in area
population proportions.
}
\examples{
x <- slot(GreHSize, 'data')[ ,3:5]
Eta2(x)
}
\references{
Bell W. (1954) \emph{A probability model for the
measurement of ecological segregation}. Social Forces 32(4),
pp. 357-364

Massey D. S. and Denton N. A. (1988) \emph{The
dimensions of residential segregation}. Social Forces 67(2),
pp. 281-315.
}
\seealso{
Bell's isolation index: \code{\link{xPx}}

Interaction index: \code{\link{xPy}}
}

