% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.OHPL.R
\name{cv.OHPL}
\alias{cv.OHPL}
\title{Cross-Validation for Ordered Homogeneity Pursuit Lasso}
\usage{
cv.OHPL(X.cal, y.cal, maxcomp, gamma = seq(0.1, 0.9, 0.1), X.test, y.test,
  cv.folds = 5L, G = 30L, type = c("max", "median"), scale = TRUE,
  pls.method = "simpls")
}
\arguments{
\item{X.cal}{Predictor matrix (training)}

\item{y.cal}{Response matrix with one column (training)}

\item{maxcomp}{Maximum number of components for PLS}

\item{gamma}{A vector of the gamma sequence between (0, 1).}

\item{X.test}{X.test Predictor matrix (test)}

\item{y.test}{y.test Response matrix with one column (test)}

\item{cv.folds}{Number of cross-validation folds}

\item{G}{Maximum number of variable groups}

\item{type}{Find the maximum absolute correlation (\code{"max"})
or find the median of absolute correlation (\code{"median"}).
Default is \code{"max"}.}

\item{scale}{Should the predictor matrix be scaled?
Default is \code{TRUE}.}

\item{pls.method}{Method for fitting the PLS model.
Default is \code{"simpls"}. See the details section
in \code{\link[pls]{plsr}} for all possible options.}
}
\value{
A list containing the optimal model, RMSEP, Q2,
and other evaluation metrics. Also the optimal number
of groups to use in group lasso.
}
\description{
This function uses cross-validation to help select the
optimal number of variable groups and the value of gamma.
}
\examples{
data("wheat")

X = wheat$x
y = wheat$protein
n = nrow(wheat$x)

set.seed(1001)
samp.idx = sample(1L:n, round(n * 0.7))
X.cal = X[samp.idx, ]
y.cal = y[samp.idx]
X.test = X[-samp.idx, ]
y.test = y[-samp.idx]

# This needs to run for a while
\dontrun{
cv.fit = cv.OHPL(
  x, y, maxcomp = 6, gamma = seq(0.1, 0.9, 0.1),
  x.test, y.test, cv.folds = 5, G = 30, type = "max")
# the optimal G and gamma
cv.fit$opt.G
cv.fit$opt.gamma}
}

