% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setEvents.R
\name{setEvents}
\alias{setEvents}
\title{Setting Events}
\usage{
setEvents(odenet, events, type = "dirac")
}
\arguments{
\item{odenet}{[\code{ODEnetwork}]\cr
List of class \code{\link{ODEnetwork}}.}

\item{events}{[\code{data.frame}]\cr
Data frame with a time base and named column per variable.
See \code{\link{events}} for detailed definition of \code{events}.}

\item{type}{[\code{character}]\cr
The type of the events to use.
Possible values are \code{dirac}, \code{constant} or \code{linear}.\cr
Type \code{dirac} sets the current state at a given time point to a new value.
\code{Constant} sets the state to the given value and the state does not change until
setting new value or the end of \code{events}.
\code{Linear} interpolates linear between \code{events} and sets the state variables
to this value.\cr
Default is \code{dirac}.}
}
\value{
an extended list of class [\code{\link{ODEnetwork}}].
}
\description{
Sets different types of events for the given \code{\link{ODEnetwork}}.
}
\examples{
masses <- 1
dampers <- as.matrix(1.5)
springs <- as.matrix(4)
odenet <- ODEnetwork(masses, dampers, springs)
eventdat <- data.frame(  var = c("x.1", "x.1")
                       , time = c(1, 3)
                       , value = c(1, 3)
                       , stringsAsFactors = TRUE
                       )
odenet <- setState(odenet, 0, 0)
odenet <- setEvents(odenet, eventdat)
odenet <- simuNetwork(odenet, seq(0, 10, by = 0.1))
plot(odenet)
}
