% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_data_functions.R
\name{plot.raster_data}
\alias{plot.raster_data}
\title{A plot function for data in raster format}
\usage{
\method{plot}{raster_data}(x, ..., facet_label = NULL)
}
\arguments{
\item{x}{Either data that is in raster format, or a string containing the
name of a file that has data in raster format.}

\item{...}{This is needed to conform to the plot generic interface.}

\item{facet_label}{If this is set to a string that is the name of one of the
labels in the raster data, then the raster plots will be faceted by
this label.}
}
\value{
Returns a ggplot object that plots the raster data.
}
\description{
This function will plot data that is in raster format. If the data is
a spike train consisting of only 0's and 1's then it will create a plot
of spikes as black tick marks on a white background. If the raster data
contains continuous data, then the plot will be color coded.
}
