% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HessianMLP.R
\name{HessianMLP}
\alias{HessianMLP}
\alias{HessianMLP.default}
\alias{HessianMLP.train}
\alias{HessianMLP.H2OMultinomialModel}
\alias{HessianMLP.H2ORegressionModel}
\alias{HessianMLP.list}
\alias{HessianMLP.mlp}
\alias{HessianMLP.nn}
\alias{HessianMLP.nnet}
\alias{HessianMLP.nnetar}
\alias{HessianMLP.numeric}
\title{Sensitivity of MLP models}
\usage{
HessianMLP(
  MLP.fit,
  .returnSens = TRUE,
  plot = TRUE,
  .rawSens = FALSE,
  sens_origin_layer = 1,
  sens_end_layer = "last",
  sens_origin_input = TRUE,
  sens_end_input = FALSE,
  ...
)

\method{HessianMLP}{default}(
  MLP.fit,
  .returnSens = TRUE,
  plot = TRUE,
  .rawSens = FALSE,
  sens_origin_layer = 1,
  sens_end_layer = "last",
  sens_origin_input = TRUE,
  sens_end_input = FALSE,
  trData,
  actfunc = NULL,
  deractfunc = NULL,
  der2actfunc = NULL,
  preProc = NULL,
  terms = NULL,
  output_name = NULL,
  ...
)

\method{HessianMLP}{train}(
  MLP.fit,
  .returnSens = TRUE,
  plot = TRUE,
  .rawSens = FALSE,
  sens_origin_layer = 1,
  sens_end_layer = "last",
  sens_origin_input = TRUE,
  sens_end_input = FALSE,
  ...
)

\method{HessianMLP}{H2OMultinomialModel}(
  MLP.fit,
  .returnSens = TRUE,
  plot = TRUE,
  .rawSens = FALSE,
  sens_origin_layer = 1,
  sens_end_layer = "last",
  sens_origin_input = TRUE,
  sens_end_input = FALSE,
  ...
)

\method{HessianMLP}{H2ORegressionModel}(
  MLP.fit,
  .returnSens = TRUE,
  plot = TRUE,
  .rawSens = FALSE,
  sens_origin_layer = 1,
  sens_end_layer = "last",
  sens_origin_input = TRUE,
  sens_end_input = FALSE,
  ...
)

\method{HessianMLP}{list}(
  MLP.fit,
  .returnSens = TRUE,
  plot = TRUE,
  .rawSens = FALSE,
  sens_origin_layer = 1,
  sens_end_layer = "last",
  sens_origin_input = TRUE,
  sens_end_input = FALSE,
  trData,
  actfunc,
  ...
)

\method{HessianMLP}{mlp}(
  MLP.fit,
  .returnSens = TRUE,
  plot = TRUE,
  .rawSens = FALSE,
  sens_origin_layer = 1,
  sens_end_layer = "last",
  sens_origin_input = TRUE,
  sens_end_input = FALSE,
  trData,
  preProc = NULL,
  terms = NULL,
  ...
)

\method{HessianMLP}{nn}(
  MLP.fit,
  .returnSens = TRUE,
  plot = TRUE,
  .rawSens = FALSE,
  sens_origin_layer = 1,
  sens_end_layer = "last",
  sens_origin_input = TRUE,
  sens_end_input = FALSE,
  preProc = NULL,
  terms = NULL,
  ...
)

\method{HessianMLP}{nnet}(
  MLP.fit,
  .returnSens = TRUE,
  plot = TRUE,
  .rawSens = FALSE,
  sens_origin_layer = 1,
  sens_end_layer = "last",
  sens_origin_input = TRUE,
  sens_end_input = FALSE,
  trData,
  preProc = NULL,
  terms = NULL,
  ...
)

\method{HessianMLP}{nnetar}(
  MLP.fit,
  .returnSens = TRUE,
  plot = TRUE,
  .rawSens = FALSE,
  sens_origin_layer = 1,
  sens_end_layer = "last",
  sens_origin_input = TRUE,
  sens_end_input = FALSE,
  ...
)

\method{HessianMLP}{numeric}(
  MLP.fit,
  .returnSens = TRUE,
  plot = TRUE,
  .rawSens = FALSE,
  sens_origin_layer = 1,
  sens_end_layer = "last",
  sens_origin_input = TRUE,
  sens_end_input = FALSE,
  trData,
  actfunc = NULL,
  preProc = NULL,
  terms = NULL,
  ...
)
}
\arguments{
\item{MLP.fit}{fitted neural network model}

\item{.returnSens}{DEPRECATED}

\item{plot}{\code{logical} whether or not to plot the analysis. By default is
\code{TRUE}.}

\item{.rawSens}{DEPRECATED}

\item{sens_origin_layer}{\code{numeric} specifies the layer of neurons with
respect to which the derivative must be calculated. The input layer is
specified by 1 (default).}

\item{sens_end_layer}{\code{numeric} specifies the layer of neurons of which
the derivative is calculated. It may also be 'last' to specify the output
layer (default).}

\item{sens_origin_input}{\code{logical} specifies if the derivative must be
calculated with respect to the inputs (\code{TRUE}) or output
(\code{FALSE}) of the \code{sens_origin_layer} layer of the model. By
default is \code{TRUE}.}

\item{sens_end_input}{\code{logical} specifies if the derivative calculated
is of the output (\code{FALSE}) or from the input (\code{TRUE}) of the
\code{sens_end_layer} layer of the model. By default is \code{FALSE}.}

\item{...}{additional arguments passed to or from other methods}

\item{trData}{\code{data.frame} containing the data to evaluate the sensitivity of the model}

\item{actfunc}{\code{character} vector indicating the activation function of each
neurons layer.}

\item{deractfunc}{\code{character} vector indicating the derivative of the activation
function of each neurons layer.}

\item{der2actfunc}{\code{character} vector indicating the second derivative of the activation
function of each neurons layer.}

\item{preProc}{preProcess structure applied to the training data. See also
\code{\link[caret]{preProcess}}}

\item{terms}{function applied to the training data to create factors. See
also \code{\link[caret]{train}}}

\item{output_name}{\code{character} name of the output variable in order to
avoid changing the name of the output variable in \code{trData} to
'.outcome'}
}
\value{
\code{SensMLP} object with the sensitivity metrics and sensitivities of
the MLP model passed to the function.
}
\description{
Function for evaluating the sensitivities of the inputs
  variables in a mlp model
}
\details{
In case of using an input of class \code{factor} and a package which
  need to enter the input data as matrix, the dummies must be created before
  training the neural network.

  After that, the training data must be given to the function using the
  \code{trData} argument.
}
\section{Plots}{
 \itemize{ \item Plot 1: colorful plot with the classification
  of the classes in a 2D map \item Plot 2: b/w plot with probability of the
  chosen class in a 2D map \item Plot 3: plot with the stats::predictions of
  the data provided }
}

\examples{
## Load data -------------------------------------------------------------------
data("DAILY_DEMAND_TR")
fdata <- DAILY_DEMAND_TR
## Parameters of the NNET ------------------------------------------------------
hidden_neurons <- 5
iters <- 100
decay <- 0.1

################################################################################
#########################  REGRESSION NNET #####################################
################################################################################
## Regression dataframe --------------------------------------------------------
# Scale the data
fdata.Reg.tr <- fdata[,2:ncol(fdata)]
fdata.Reg.tr[,3] <- fdata.Reg.tr[,3]/10
fdata.Reg.tr[,1] <- fdata.Reg.tr[,1]/1000

# Normalize the data for some models
preProc <- caret::preProcess(fdata.Reg.tr, method = c("center","scale"))
nntrData <- predict(preProc, fdata.Reg.tr)

#' ## TRAIN nnet NNET --------------------------------------------------------
# Create a formula to train NNET
form <- paste(names(fdata.Reg.tr)[2:ncol(fdata.Reg.tr)], collapse = " + ")
form <- formula(paste(names(fdata.Reg.tr)[1], form, sep = " ~ "))

set.seed(150)
nnetmod <- nnet::nnet(form,
                      data = nntrData,
                      linear.output = TRUE,
                      size = hidden_neurons,
                      decay = decay,
                      maxit = iters)
# Try HessianMLP
NeuralSens::HessianMLP(nnetmod, trData = nntrData, plot = FALSE)
\donttest{
# Try HessianMLP to calculate sensitivities with respect to output of hidden neurones
NeuralSens::HessianMLP(nnetmod, trData = nntrData,
                             sens_origin_layer = 2,
                             sens_end_layer = "last",
                             sens_origin_input = FALSE,
                             sens_end_input = FALSE)
## Train caret NNET ------------------------------------------------------------
# Create trainControl
ctrl_tune <- caret::trainControl(method = "boot",
                                 savePredictions = FALSE,
                                 summaryFunction = caret::defaultSummary)
set.seed(150) #For replication
caretmod <- caret::train(form = DEM~.,
                              data = fdata.Reg.tr,
                              method = "nnet",
                              linout = TRUE,
                              tuneGrid = data.frame(size = 3,
                                                    decay = decay),
                              maxit = iters,
                              preProcess = c("center","scale"),
                              trControl = ctrl_tune,
                              metric = "RMSE")

# Try HessianMLP
NeuralSens::HessianMLP(caretmod)

## Train h2o NNET --------------------------------------------------------------
# Create a cluster with 4 available cores
h2o::h2o.init(ip = "localhost",
              nthreads = 4,
              max_mem_size = "2g")

# Reset the cluster
h2o::h2o.removeAll()
fdata_h2o <- h2o::as.h2o(x = fdata.Reg.tr, destination_frame = "fdata_h2o")

set.seed(150)
h2omod <-h2o:: h2o.deeplearning(x = names(fdata.Reg.tr)[2:ncol(fdata.Reg.tr)],
                                     y = names(fdata.Reg.tr)[1],
                                     distribution = "AUTO",
                                     training_frame = fdata_h2o,
                                     standardize = TRUE,
                                     activation = "Tanh",
                                     hidden = c(hidden_neurons),
                                     stopping_rounds = 0,
                                     epochs = iters,
                                     seed = 150,
                                     model_id = "nnet_h2o",
                                     adaptive_rate = FALSE,
                                     rate_decay = decay,
                                     export_weights_and_biases = TRUE)

# Try HessianMLP
NeuralSens::HessianMLP(h2omod)

# Turn off the cluster
h2o::h2o.shutdown(prompt = FALSE)
rm(fdata_h2o)

## Train neural NNET -----------------------------------------------------------
set.seed(150)
neuralmod <- neural::mlptrain(as.matrix(nntrData[,2:ncol(nntrData)]),
                                   hidden_neurons,
                                   as.matrix(nntrData[1]),
                                   it=iters,
                                   visual=FALSE)

# Try HessianMLP
trData <- nntrData
NeuralSens::HessianMLP(neuralmod, trData = trData, output_name = "DEM")

## Train RSNNS NNET ------------------------------------------------------------
# Normalize data using RSNNS algorithms
trData <- as.data.frame(RSNNS::normalizeData(fdata.Reg.tr))
names(trData) <- names(fdata.Reg.tr)
set.seed(150)
RSNNSmod <-RSNNS::mlp(x = trData[,2:ncol(trData)],
                           y = trData[,1],
                           size = hidden_neurons,
                           linOut = TRUE,
                           learnFuncParams=c(decay),
                           maxit=iters)

# Try HessianMLP
NeuralSens::HessianMLP(RSNNSmod, trData = trData, output_name = "DEM")

## TRAIN neuralnet NNET --------------------------------------------------------
# Create a formula to train NNET
form <- paste(names(fdata.Reg.tr)[2:ncol(fdata.Reg.tr)], collapse = " + ")
form <- formula(paste(names(fdata.Reg.tr)[1], form, sep = " ~ "))

set.seed(150)
nnmod <- neuralnet::neuralnet(form,
                                   nntrData,
                                   linear.output = TRUE,
                                   rep = 1,
                                   hidden = hidden_neurons,
                                   lifesign = "minimal",
                                   threshold = 7,
                                   stepmax = iters,
                                   learningrate = decay,
                                   act.fct = "tanh")

# Try HessianMLP
NeuralSens::HessianMLP(nnmod)


## USE DEFAULT METHOD ----------------------------------------------------------
NeuralSens::HessianMLP(caretmod$finalModel$wts,
                            trData = fdata.Reg.tv,
                            mlpstr = caretmod$finalModel$n,
                            coefnames = caretmod$coefnames,
                            actfun = c("linear","sigmoid","linear"),
                            output_name = "DEM")

################################################################################
#########################  CLASSIFICATION NNET #################################
################################################################################
## Regression dataframe --------------------------------------------------------
# Scale the data
fdata.Reg.cl <- fdata[,2:ncol(fdata)]
fdata.Reg.cl[,2:3] <- fdata.Reg.cl[,2:3]/10
fdata.Reg.cl[,1] <- fdata.Reg.cl[,1]/1000

# Normalize the data for some models
preProc <- caret::preProcess(fdata.Reg.cl, method = c("center","scale"))
nntrData <- predict(preProc, fdata.Reg.cl)

# Factorize the output
fdata.Reg.cl$DEM <- factor(round(fdata.Reg.cl$DEM, digits = 1))

# Normalize the data for some models
preProc <- caret::preProcess(fdata.Reg.cl, method = c("center","scale"))
nntrData <- predict(preProc, fdata.Reg.cl)

## Train caret NNET ------------------------------------------------------------
# Create trainControl
ctrl_tune <- caret::trainControl(method = "boot",
                                 savePredictions = FALSE,
                                 summaryFunction = caret::defaultSummary)
set.seed(150) #For replication
caretmod <- caret::train(form = DEM~.,
                                data = fdata.Reg.cl,
                                method = "nnet",
                                linout = FALSE,
                                tuneGrid = data.frame(size = hidden_neurons,
                                                      decay = decay),
                                maxit = iters,
                                preProcess = c("center","scale"),
                                trControl = ctrl_tune,
                                metric = "Accuracy")

# Try HessianMLP
NeuralSens::HessianMLP(caretmod)

## Train h2o NNET --------------------------------------------------------------
# Create local cluster with 4 available cores
h2o::h2o.init(ip = "localhost",
              nthreads = 4,
              max_mem_size = "2g")

# Reset the cluster
h2o::h2o.removeAll()
fdata_h2o <- h2o::as.h2o(x = fdata.Reg.cl, destination_frame = "fdata_h2o")

set.seed(150)
h2omod <- h2o::h2o.deeplearning(x = names(fdata.Reg.cl)[2:ncol(fdata.Reg.cl)],
                                       y = names(fdata.Reg.cl)[1],
                                       distribution = "AUTO",
                                       training_frame = fdata_h2o,
                                       standardize = TRUE,
                                       activation = "Tanh",
                                       hidden = c(hidden_neurons),
                                       stopping_rounds = 0,
                                       epochs = iters,
                                       seed = 150,
                                       model_id = "nnet_h2o",
                                       adaptive_rate = FALSE,
                                       rate_decay = decay,
                                       export_weights_and_biases = TRUE)

# Try HessianMLP
NeuralSens::HessianMLP(h2omod)

# Apaga el cluster
h2o::h2o.shutdown(prompt = FALSE)
rm(fdata_h2o)

## Train neural NNET -----------------------------------------------------------
# set.seed(150)
# neuralmod <-mlptrain(as.matrix(nntrData[,2:ncol(nntrData)]),
#                           hidden_neurons,
#                           as.matrix(nntrData[1]),
#                           it=iters,
#                           visual=FALSE)
#
# # Try HessianMLP
# NeuralSens::HessianMLP(neuralmod, trData = trData)

# ## Train RSNNS NNET ------------------------------------------------------------
# # Normalize data using RSNNS algorithms
# trData <- as.data.frame(RSNNS::normalizeData(fdata.Reg.cl))
# names(trData) <- names(fdata.Reg.tr)
# set.seed(150)
# RSNNSmod <- RSNNS::mlp(x = trData[,2:ncol(trData)],
#                      y = trData[,1],
#                      size = hidden_neurons,
#                      linOut = FALSE,
#                      learnFuncParams=c(decay),
#                      maxit=iters)
#
# # Try HessianMLP
# NeuralSens::HessianMLP(RSNNSmod, trData = trData, output_name = "DEM")

## TRAIN neuralnet NNET --------------------------------------------------------
# Create a formula to train NNET
# form <- paste(names(fdata.Reg.tr)[2:ncol(fdata.Reg.tr)], collapse = " + ")
# form <- formula(paste(names(fdata.Reg.tr)[1], form, sep = " ~ "))
#
# set.seed(150)
# nnmod <- neuralnet(form,
#                    nntrData,
#                    linear.output = FALSE,
#                    rep = 1,
#                    hidden = hidden_neurons,
#                    lifesign = "minimal",
#                    threshold = 4,
#                    stepmax = iters,
#                    learningrate = decay,
#                    act.fct = "tanh")
#
# # Try HessianMLP
# NeuralSens::HessianMLP(nnmod)

## TRAIN nnet NNET --------------------------------------------------------
# Create a formula to train NNET
form <- paste(names(fdata.Reg.tr)[2:ncol(fdata.Reg.tr)], collapse = " + ")
form <- formula(paste(names(fdata.Reg.tr)[1], form, sep = " ~ "))

set.seed(150)
nnetmod <- nnet::nnet(form,
                      data = nntrData,
                      linear.output = TRUE,
                      size = hidden_neurons,
                      decay = decay,
                      maxit = iters)
# Try HessianMLP
NeuralSens::HessianMLP(nnetmod, trData = nntrData)
}
}
\references{
\url{https://www.researchgate.net/publication/220577792_Use_of_some_sensitivity_criteria_for_choosing_networks_with_good_generalization_ability}
}
