% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gain.functions.R
\name{gain.functions}
\alias{gain.functions}
\alias{gfcnv_logdet}
\alias{gfcnv_logdet_val}
\alias{gdcnv_lmfit}
\title{MFCF Gain Functions}
\usage{
"logLik"
gfcnv_logdet(data, clique_id, cl, excl_nodes, ctreeControl)

"logLik.val"
gfcnv_logdet_val(data, clique_id, cl, excl_nodes, ctreeControl)

"rSquared.val"
gdcnv_lmfit(data, clique_id, cl, excl_nodes, ctreeControl)
}
\arguments{
\item{data}{Matrix or data frame.
Can be a dataset or a correlation matrix}

\item{clique_id}{Numeric.
Number corresponding to clique to add another node to}

\item{cl}{List.
List of cliques already assembled in the network}

\item{excl_nodes}{Numeric vector.
A vector of numbers corresponding to nodes not already
included in the network}

\item{ctreeControl}{List (length = 5).
A list containing several parameters for controlling
the clique tree sizes:

\itemize{

\item{\code{min_size}}
{Numeric. Minimum number of nodes allowed per
clique. Defaults to \code{1}}

\item{\code{max_size}}
{Numeric. Maximum number of nodes allowed per
clique. Defaults to \code{8}}

\item{\code{pval}}
{Numeric. \emph{p}-value used to determine cut-offs for nodes
to include in a clique. Defaults to \code{.05}}

\item{\code{pen}}
{Numeric. Multiplies the number of edges added to penalize 
complex models. Similar to the penalty term in AIC}

\item{\code{drop_sep}}
{Boolean. This parameter influences the MFCF only. If TRUE any
separator can be used only once, as in the TMFG.}

\item{\code{use_returns}}
{Boolean. Only used in rSquared.val. If set to TRUE the regression is 
performed on log-returns. Defaults to \code{FALSE}}

}}
}
\value{
Returns the value with the maximum gain
}
\description{
These functions maximize a gain criterion
for adding a node to a clique (and the larger network).
The flexibility of \code{\link[NetworkToolbox]{MFCF}}
allows for any multivariate function to be used as a
scoring function.

\itemize{

\item{\code{"logLik"}}

{The log determinant of the matrix restricted to 
the separator minus the log determinant of the matrix restricted
to the clique.}

\item{\code{"logLik.val"}}

{\code{"logLik"} with a further validation based on
the likelihood ratio. If the increase in gain is not significant
the routine stops adding nodes to the separator.}

\item{\code{"rSquared.val"}}

{The R squared from the regression of the node against the clique. Only
the clique nodes with a regression coefficient significantly different
from zero are added to the separator / new clique. The gain is different from 
zero only if the F-values is significant, It assumed that the \code{data} 
matrix is a dataset of realizations (i.e., \code{p}
variables and \code{n} observations).} 

}
}
\references{
Massara, G. P. & Aste, T. (2019).
Learning clique forests.
\emph{ArXiv}.
}
\author{
Guido Previde Massara <gprevide@gmail.com> and Alexander Christensen <alexpaulchristensen@gmail.com>
}
