% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{neuralcorrtest}
\alias{neuralcorrtest}
\title{Neural-Behavioral Correlation Test}
\usage{
neuralcorrtest(bstat, nstat)
}
\arguments{
\item{bstat}{Behavioral statistic for each participant with neural data}

\item{nstat}{A statistic vector (whole-network) or matrix (ROI) from the \emph{neuralstat} function}
}
\value{
Returns correlation test statistics for given statistics
}
\description{
Correlational test for global or local network characteristics of neural network data with behavioral data
(still in testing phase)
}
\examples{
\dontrun{
neuralarray <- convertConnBrainMat()

filteredneuralarray <- neuralnetfilter(neuralarray, method = "threshold", thres = .50)

AverageShortestPathLength <- neuralstat(filteredneuralarray, statistic = "ASPL")

Degree <- neuralstat(filteredneuralarray, statistic = "deg")

bstat <- iq

WholeNetwork_corr <- neuralcorrtest(bstat, AverageShortestPathLength)

ROI_corr <- neuralcorrtest(bstat, Degree)
}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
