% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeBlockNetworkChange.R
\name{MakeBlockNetworkChange}
\alias{MakeBlockNetworkChange}
\title{Build a synthetic block-structured temporal data with breaks}
\usage{
MakeBlockNetworkChange(n = 10, break.point = 0.5, block.number = 3,
  base.prob = 0.05, block.prob = 0.5, shape = 10, T = 40,
  type = "merge")
}
\arguments{
\item{n}{The number of nodes within a block. The total number of nodes is n*block.number.}

\item{break.point}{The point of break. 0 indicates the beginning, 0.5 indicates the middle,
and 1 indicates the end.}

\item{block.number}{The number of blocks.}

\item{base.prob}{The probability of link among non-block members.}

\item{block.prob}{The probability of link among within-block members.}

\item{shape}{The speed of breaks.
The larger shape is, the faster the transition is. 0 is the minimum.}

\item{T}{The length of time.}

\item{type}{The type of network changes. Options are "constant", "merge", "split",
"merge-split", "split-merge." If "constant" is chosen, the number of breaks is zero.
If "merge" or "split" is chosen, the number of breaks is one.
If either "merge-split" or "split-merge" is chosen, the number of breaks is two.}
}
\value{
output  An output of \code{MakeBlockNetworkChange} contains a symmetric block-structured temporal network data set with breaks.
}
\description{
MakeBlockNetworkChange generates a block-structured temporal data with breaks
}
