\name{Shortest Paths Matrices}
\alias{Con10}
\alias{Con100}
\alias{Con1000}
\alias{Dis10}
\alias{Dis100}
\alias{Dis1000}
\docType{data}
\title{
Matrices of shortest paths corresponding to Erdos-Renyi models for
different number of vertices (10, 100 and 1000), which are either
connected (e.g. Con10) or disconnected (e.g. Dis10).
}
\description{
  Matrices of shortest paths for random networks with 10, 100 and 1000
  vertices. These matrices were generated by using the random.graph.game()
  function in the igraph package, with either 1/ (e.g. Con10) or 1/10
  (e.g. Dis10) of the edges of the corresponding saturated graph. 
}
\usage{
   data(Con10)
   data(Con100)
   data(Con1000)
   data(Dis10)
   data(Dis100)
   data(Dis1000)
}
\format{
  Each matrix is a \eqn{Nv*Nv} matrix of shortest paths, where \eqn{Nv} is the number of
  vertices.
}
\references{  
     Erdos, P. and Renyi, A., On random graphs, _Publicationes
     Mathematicae_ 6, 290-297 (1959).
}
\examples{
data(Dis10)
naHeatmap(Dis10)

data(Con100);
naHeatmap(Con100)
}
\keyword{datasets}


%%%%%%%%%%%%%%%%%%%%%%%%%%
% Codes for generating these matrices:

%%% Connected ones. 
%n <- 10; Con10 <- shortest.paths(random.graph.game(n,maxE(n)/2,type="gnm")); sum(is.finite(Con10))/n^2
%n <- 100; Con100 <- shortest.paths(random.graph.game(n,maxE(n)/2,type="gnm")); sum(is.finite(Con100))/n^2
%n <- 1000; Con1000 <- shortest.paths(random.graph.game(n,maxE(n)/2,type="gnm")); sum(is.finite(Con1000))/n^2

%%% Disconnected ones. 
%n <- 10; Dis10 <- shortest.paths(random.graph.game(n,n/2,type="gnm")); sum(is.finite(Dis10))/n^2
%n <- 100; Dis100 <- shortest.paths(random.graph.game(n,n/2,type="gnm")); sum(is.finite(Dis100))/n^2
%n <- 1000; Dis1000 <- shortest.paths(random.graph.game(n,n/2,type="gnm")); sum(is.finite(Dis1000))/n^2

%ls <- c("Con10","Con100","Con1000","Dis10","Dis100","Dis1000")
%package.skeleton(name="mypackage",path="~/pro/mypackage",list=ls)

