% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agentset-functions.R
\docType{methods}
\name{NLall}
\alias{NLall}
\alias{all}
\alias{NLall,matrix,worldMatrix,missing-method}
\alias{NLall,matrix,worldArray,character-method}
\alias{NLall,agentMatrix,missing,character-method}
\title{All agents?}
\usage{
NLall(agents, world, var, val)

\S4method{NLall}{matrix,worldMatrix,missing}(agents, world, val)

\S4method{NLall}{matrix,worldArray,character}(agents, world, var, val)

\S4method{NLall}{agentMatrix,missing,character}(agents, var, val)
}
\arguments{
\item{agents}{Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second
              column \code{pycor} representing the \code{patches} coordinates, or

              \code{AgentMatrix} object representing the moving \code{agents}.}

\item{world}{\code{WorldMatrix} or \code{worldArray} object.}

\item{var}{Character. The name of the selected \code{agents} variable.
If \code{agents} are \code{patches} and the \code{world} is a
\code{worldMatrix} object, \code{var} must not be provided. If
\code{agents} are \code{patches} and the \code{world} is a \code{worldArray}
object, \code{var} is the name of the layer to use to define the \code{patches}
values. If \code{agents} are \code{turtles}, \code{var} is one of
the \code{turtles}' variable and can be equal to \code{xcor},
\code{ycor}, any of the variables created when \code{turtles} were created,
as well as any variable created using \code{turtlesOwn()}.}

\item{val}{Numeric or character. Vector of any length.}
}
\value{
Logical. \code{TRUE} if all the \code{agents} have their variable equal to
        \code{val}, \code{FALSE} otherwise.
}
\description{
Report \code{TRUE} if all \code{agents} have their variable equal to a given value,
report \code{FALSE} otherwise.
}
\details{
\code{world} must not be provided if \code{agents} are turtles.
}
\examples{
# Patches
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4, data = runif(25))
NLall(agents = patches(w1), world = w1, val = 5)
w2 <- w1
w2 <- NLset(world = w1, agents = patches(w1), val = 5)
NLall(agents = patches(w2), world = w2, val = 5)

# Turtles
t1 <- createTurtles(n = 5, coords = cbind(xcor = 1, ycor = 1), heading = c(1, 2, 2, 1, 2))
NLall(agents = t1, var = "xcor", val = 1)
NLall(agents = t1, var = "heading", val = 2)


}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#all}
}
\author{
Sarah Bauduin
}
