% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nematode_metabolic_footprints.R
\name{NMF}
\alias{NMF}
\alias{NMF.data.frame}
\alias{NMF.matrix}
\alias{NMF.default}
\title{Nematode Metabolic Footprints (NMF) Calculation}
\usage{
NMF(data, abundance, type = "All", ...)

\method{NMF}{data.frame}(data, abundance, type = "All", ...)

\method{NMF}{matrix}(data, abundance, type = "All", ...)

\method{NMF}{default}(data, abundance, type = "all", ...)
}
\arguments{
\item{data}{\code{data.frame} or \code{matrix}. The nematode abundance table where rows represent samples and columns represent nematode genera.
Each element indicates the count of a specific nematode genus in the corresponding sample. Row names must be sample names, and column names must be nematode genus names.}

\item{abundance}{\code{data.frame}. A data frame with sample names as row names and a single column containing the total nematode abundance for each sample.}

\item{type}{Character vector specifying the type(s) of NMF to calculate. \code{All} is the default value. Valid options include:
\itemize{
\item "BaMF" - Bacterial Feeders Nematode Metabolic Footprints
\item "FuMF" - Fungal Feeders Nematode Metabolic Footprints
\item "PpMF" - Plant Feeders Nematode Metabolic Footprints
\item "OpMF" - Omnivore/Predator Nematode Metabolic Footprints
\item "Fe" - Enrichment Footprints (CP group <= 2)
\item "Fs" - Structure Footprints (CP group > 2)
\item "TNMF" - Total Nematode Metabolic Footprints
\item "FMF" - Functional Metabolic Footprints (product of Fe and Fs)
\item "All" - Calculate all the above types
}}

\item{...}{Additional arguments (currently unused).}
}
\value{
A data.frame containing the calculated NMF values for each sample. The columns represent different NMF types, and the rows correspond to samples.
}
\description{
This function calculates various Nematode Metabolic Footprints (NMF) based on the input data and abundance information.
It supports multiple types of NMF calculations and can handle data in different formats (data.frame or matrix).
}
\examples{
data <- data.frame(
  Cephalobus = c(10, 20, 30),
  Eucephalobus = c(5, 10, 12),
  Acrobeloides = c(1, 2, 3),
  Caenorhabditis = c(5, 8, 15),
  Aphelenchus = c(5, 13, 11),
  Leptonchus = c(3, 10, 15),
  Pratylenchus = c(9, 2, 15),
  Tylenchus = c(5, 0, 15),
  Mesodorylaimus = c(7, 10, 18),
  Discolaimus = c(1, 10, 25),
  row.names = c("Sample1", "Sample2", "Sample3")
)
abundance <- data.frame(
  Abundance = c(100, 200, 300),
  row.names = c("Sample1", "Sample2", "Sample3")
)
result <- NMF(data, abundance, type = "All")
print(result)
}
