% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nail_sort.R
\name{nail_sort}
\alias{nail_sort}
\title{Sort textual data}
\usage{
nail_sort(
  dataset,
  name_size = 3,
  stimulus_id = "stimulus",
  introduction = "",
  measure = "",
  nb_max = 6,
  generate = FALSE
)
}
\arguments{
\item{dataset}{a data frame where each row is a stimulus and each column is an assessor.}

\item{name_size}{the maximum number of words in a group name created by the LLM.}

\item{stimulus_id}{the nature of the stimulus. Customizing it is highly recommended.}

\item{introduction}{the introduction to the LLM prompt.}

\item{measure}{the type of measure used in the experiment.}

\item{nb_max}{the maximum number of clusters the LLM can form per assessor.}

\item{generate}{a boolean that indicates whether to generate the LLM response. If FALSE, the function only returns the prompt.}
}
\value{
A list consisting of:
\itemize{
\item a list of prompts (one per assessor);
\item a data frame with the group names.
}
}
\description{
Group textual data according to their similarity, in a context in which the assessors have commented on a set of stimuli.
}
\details{
This function uses a while loop to ensure that the LLM gives the right number of groups. Therefore, customizing the stimulus ID, prompt introduction and measure is highly recommended; a clear prompt can help the LLM finish its task faster.
}
\examples{
\dontrun{
# Processing time is often longer than ten seconds
# because the function uses a large language model.

library(NaileR)
data(beard_wide)

intro_beard <- "As a barber, you make
recommendations based on consumers comments.
Examples of consumers descriptions of beards
are as follows."
intro_beard <- gsub('\n', ' ', intro_beard) |>
stringr::str_squish()

res <- nail_sort(beard_wide[,1:5], name_size = 3,
stimulus_id = "beard", introduction = intro_beard,
measure = 'the description was', generate = TRUE)

res$dta_sort
cat(res$prompt_llm[[1]])
}
}
