% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CC.test.R
\name{CC.test}
\alias{CC.test}
\title{Random shift test of independence in a bivariate random field}
\usage{
CC.test(
  covariateA,
  covariateB,
  test.points,
  N.shifts = 999,
  radius,
  correction,
  type = "Kendall",
  verbose = FALSE
)
}
\arguments{
\item{covariateA}{first random field (object of class \code{im})}

\item{covariateB}{second random field (object of class \code{im})}

\item{test.points}{point pattern providing the set of sampling points (object of class \code{ppp})}

\item{N.shifts}{integer, how many random shifts should be performed in the random shift test}

\item{radius}{positive real number determining the radius of the disk on which the shift vectors are uniformly distributed}

\item{correction}{which correction should be applied in the random shift test (possible choices are "torus" and "variance")}

\item{type}{which test statistic should be used (possible choices are "Kendall", "Pearson" and "covariance")}

\item{verbose}{logical value indicating whether auxiliary information should be printed and auxiliary figures plotted during the computation}
}
\value{
The p-value of the random shift test of independence between a pair of random fields.
}
\description{
Nonparametric test of independence between a pair of random fields based on random shifts.
Either the torus correction or the variance correction can be used, see Mrkvička et al. (2021).
The variance correction is recommended for random fields with nontrivial autocorrelations.
}
\details{
The test statistic can be either the sample covariance or the sample Kendall's or
Pearson's correlation coefficient. The choice of the test statistic is given
by the argument \code{type}.

The torus correction can be applied for rectangular windows. On the other hand,
the variance correction is applicable both for rectangular and for irregular windows.
The choice of the correction is given
by the argument \code{correction}. Based on the simulation studies in Mrkvička et al. (2021),
the variance correction is recommended for random fields with nontrivial autocorrelations.

The two realizations of the random fields (defined on the same domain) to be tested
should be supplied in the \code{covariateA, covariateB} arguments
as objects of the class \code{im} as used in the \code{spatstat} package.
The pattern of sampling points in which the test statistic is evaluated
is given in the argument \code{test.points} as an object of the class \code{ppp}.

The shift vectors are generated from the
uniform distribution on the disk with radius given by the argument \code{radius}
and centered in the origin. The argument \code{verbose} determines if
auxiliary information and plots should be provided.
}
\examples{

library(spatstat)

set.seed(123)

elevation <- bei.extra$elev
slope <- bei.extra$grad
plot(elevation)
plot(slope)

test.points <- runifpoint(100, win=bei$window)

out1 <- CC.test(covariateA=elevation, covariateB=slope, test.points=test.points, N.shifts=999,
                radius=250, type="Kendall", correction="torus", verbose=TRUE)
out1

out2 <- CC.test(covariateA=elevation, covariateB=slope, test.points=test.points, N.shifts=999,
                radius=250, type="Kendall", correction="variance", verbose=TRUE)
out2

}
\references{
T. Mrkvička, J. Dvořák, J.A. González, J. Mateu (2021): Revisiting the random shift approach for testing in spatial statistics. Spatial Statistics 42, 100430.
}
