\name{tc}
\alias{tc}
\title{
Guess-Hollander-Proschan
}
\description{
Function to compute the asymptotic P-value for the observed Guess-Hollander-Proschan T_1 statistic.
}
\usage{
tc(x, tau, alternative = "two.sided")
}
\arguments{
  \item{x}{a vector of data of length n}
  \item{tau}{the known value of the turning point,T}
  \item{alternative}{the direction of the alternative hypothesis.  The choices are two.sided, idmrl, and dimrl with the default value being two.sided.}
}
\value{
The function returns a list with four elements:
\item{T1}{the value of the idmrl statistic}
\item{T1*}{the standardized value of the idmrl statistic}
\item{p}{the corresponding probability for T1*}
\item{sigma.hat}{the standard deviation for T1}
}
\author{
Rachel Becvarik
}
\examples{
tb<-c(43, 45, 53, 56, 56, 57, 58, 66, 67, 73, 74, 79, 80, 80, 81, 81, 81, 82, 83, 83, 84, 88,  
89,  91,  91,  92,  92,  97,  99,  99, 100, 100, 101, 102, 102, 102, 103, 104, 107, 108, 109,
113, 114, 118, 121, 123, 126, 128, 137, 138, 139, 144, 145, 147, 156, 162, 174, 178, 179, 184,
191, 198, 211, 214, 243, 249, 329, 380, 403, 511, 522, 598)
tc(tb, tau=91.9, alt="dimrl")
tc(tb, tau=91.9, alt="idmrl")
}
\keyword{Guess-Hollander-Proschan}