% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partial_Moments.R
\name{D.UPM}
\alias{D.UPM}
\title{Divergent-Upper Partial Moment
(Upper Left Quadrant 2)}
\usage{
D.UPM(degree.x, degree.y, x, y, target.x, target.y)
}
\arguments{
\item{degree.x}{integer; Degree for variable X.  \code{(degree.x = 0)} is frequency, \code{(degree.x = 1)} is area.}

\item{degree.y}{integer; Degree for variable Y.  \code{(degree.y = 0)} is frequency, \code{(degree.y = 1)} is area.}

\item{x}{a numeric vector.}

\item{y}{a numeric vector of equal length to \code{x}.}

\item{target.x}{numeric; Typically the mean of Variable X for classical statistics equivalences, but does not have to be. (Vectorized)}

\item{target.y}{numeric; Typically the mean of Variable Y for classical statistics equivalences, but does not have to be. (Vectorized)}
}
\value{
Divergent UPM of two variables
}
\description{
This function generates a divergent upper partial moment between two equal length variables for any degree or target.
}
\examples{
set.seed(123)
x <- rnorm(100) ; y <- rnorm(100)
D.UPM(0, 0, x, y, mean(x), mean(y))
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\author{
Fred Viole, OVVO Financial Systems
}
\keyword{covariance}
\keyword{moments,}
\keyword{partial}
