% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partial_Moments.R
\name{D.LPM}
\alias{D.LPM}
\title{Divergent-Lower Partial Moment
(Lower Right Quadrant 3)}
\usage{
D.LPM(degree_n, degree_q, target1, target2, variable1, variable2)
}
\arguments{
\item{degree_n}{Degree = 0 is frequency, degree = 1 is area}

\item{degree_q}{Degree = 0 is frequency, degree = 1 is area}

\item{target1}{Typically set to mean of Variable 1, but does not have to be}

\item{target2}{Typically set to mean of Variable 2, but does not have to be}

\item{variable1}{Variable 1}

\item{variable2}{Variable 2}
}
\value{
Divergent LPM of two variables
}
\description{
This function generates a multivariate divergent lower partial moment for any degree or target.
}
\examples{
set.seed(123)
x<-rnorm(100); y<-rnorm(100)
\dontrun{D.LPM(0,mean(x),mean(y),x,y)}
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{moments}
\keyword{partial}

