% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lapplydt.R
\name{lapplydt}
\alias{lapplydt}
\title{Apply function of subsets of `data.frame`, return named list}
\usage{
lapplydt(data, by, fun, drop.null = FALSE)
}
\arguments{
\item{data}{Data set to process. Must be a data.frame-like structure.}

\item{by}{Column to split data by.}

\item{fun}{function to pass to `lapply()`.}

\item{drop.null}{If some subsets return NULL, drop the empty
elements in the returned list?}
}
\value{
a list
}
\description{
Based on columns in data, run function on subsets of data and
return the results in a list, carrying names of the subsets. Say a
column is `model` and you want to create a plot, run a regression
or anything on the data for each model. In that case
lapplydt(data,by="model",fun=function(x)lm(lAUC~lDose,data=x)). The
l in lapplydt is because a list is returned (like lapply), the dt
is because the input is a data.table.
}
\details{
the name of the current dataset can be reached with the
    `.nm` variable. like
}
\examples{
pk <- readRDS(file=system.file("examples/data/xgxr2.rds",package="NMdata"))
lapplydt(pk,by="DOSE",fun=function(x) {
    message("this is subset",.nm)
    nrow(x) 
})
}
