% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CV.R
\name{CV}
\alias{CV}
\title{Calculate coefficient of variation of data}
\usage{
CV(x, log = FALSE)
}
\arguments{
\item{x}{The data}

\item{log}{If TRUE, the geometric coefficient of variation is
calculated. This is sqrt(exp(var(log(x))-1).}
}
\value{
A numeric
}
\description{
Calculate coefficient of variation of data
}
\details{
This function is intended to be used on data. For a
log-normal THETA1*EXP(OMEGA[1]) 'Nonmem' parameter, do
CV=sqrt(exp(OMEGA[1,1])-1).
}
\examples{
set.seed(139)
x1 <- rnorm(1000,mean=5)
CV(x1)
CV(x1,log=TRUE)
x2 <- exp(x1)
CV(x2)
CV(x2,log=TRUE)
}
