% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmadt.hsroc.R
\name{nmadt.hsroc}
\alias{nmadt.hsroc}
\title{Network Meta-Analysis Using the hierarchical model}
\usage{
nmadt.hsroc(nstu, K, data, testname, directory = NULL, eta = 0,
  xi_preci = 1.25, digits = 4, n.adapt = 5000, n.iter = 50000,
  n.chains = 3, n.burnin = floor(n.iter/2), n.thin = max(1,
  floor((n.iter - n.burnin)/1e+05)), conv.diag = FALSE, trace = NULL,
  dic = FALSE, mcmc.samples = FALSE)
}
\arguments{
\item{nstu}{an integer indicating the number of studies included in the dataset.}

\item{K}{an integer indicating the number of candiate test in the dataset.}

\item{data}{a list conating the input dataset to be used for meta-analysis.}

\item{testname}{a string vector of the names of the candidate tests in the dataset in the same order as presetned in the dataset.}

\item{directory}{a string specifying the designated directory to save trace plots or potential scale reduction factors calculated in the function. The default is NULL.}

\item{eta}{a number indicating the mean of log(S) and log(P) which determines the covariance matrices of the cutoff values and accuracy values respectively. The default is 0.}

\item{xi_preci}{a number indicating the precision of log(S) and log(P) which determines the covariance matrices of the cutoff values and accuracy values respectively. The default is 1.25.}

\item{digits}{a positive integer he number of digits to the right of the decimal point to keep for the results; digits=4 by default.}

\item{n.adapt}{a positive integer indicating the number of iterations for adaptation. The default is 5,000.}

\item{n.iter}{a postive integer indicating the number of iterations in each MCMC chain. The default is 50,000.}

\item{n.chains}{a postive interger indicating the number of MCMC chains. The default is 3.}

\item{n.burnin}{a positive integer indicating the number of burn-in iterations at the beginning of each chain without saving any of the posterior samples. The default is \code{floor(n.iter/2)}.}

\item{n.thin}{the thinning rate for MCMC chains, which is used to save memory and computation time when \code{n.iter} is large.
For example, the algorithm saves only one sample in every nth iteration, where n is given by \code{n.thin}.}

\item{conv.diag}{a logical value specifying whether to compute potential scale reduction factors proposed for convergence diagnostics. The default is \code{FALSE}.}

\item{trace}{a string vector containing a subset of different quantities which can be chosen from prevalence(\code{"prev"}), sensitivity (\code{"Se"}), specificity (\code{"Sp"}), positive and negative predictive values (\code{"ppv"} and \code{"npv"} repectively), positive likelihood (\code{"LRpos"}), and negative likelihood (\code{"LRneg"}).}

\item{dic}{a logical value indicating whether the function will output the deviance information criterion (DIC) statistic. The default is \code{false}.}

\item{mcmc.samples}{a logical value indicating whether the coda samples generated in the meta-analysis. The default is \code{FALSE}.}
}
\value{
A list with the raw output for graphing the results, the effect size estimates, which lists the posterior mean, standard deviation, median, and a $95$\% equal tail credible interval for the median.
}
\description{
\code{nmadt.hsroc} performs network meta-analysis of diagnostic tests using the HSROC (hierarchical summary receiver operating characteristic) model \insertCite{lian2018bayesian}{NMADiagT} and outputs estimations of accuracy measurements.
}
\examples{
\donttest{
kangdata<-read.csv(file=system.file("extdata","kangdata.csv",package="NMADiagT"),
header=TRUE, sep=",")
set.seed(9)
kang.out.hsroc <- nmadt.hsroc(nstu=12, K=2, data=kangdata, testname=c("D-dimer","Ultrasonography"))
}
}
\references{
\insertRef{lian2018bayesian}{NMADiagT}
}
