% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_raster2tibble.R
\name{util_raster2tibble}
\alias{util_raster2tibble}
\title{Converts raster data into tibble}
\usage{
util_raster2tibble(x)
}
\arguments{
\item{x}{[\code{Raster* object}]}
}
\value{
a tibble
}
\description{
Writes spatial raster values into tibble and adds coordinates.
}
\details{
You will loose any resolution, extent or reference system.
The output is raw tiles.
}
\examples{
library(ggplot2)
rndMap <- nlm_random(16, 9)
maptib <- util_raster2tibble(rndMap)
ggplot(maptib, aes(x,y)) +
  coord_fixed() +
  geom_raster(aes(fill = z))

}
