% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best_fit_beta.R
\name{match_control_group}
\alias{match_control_group}
\title{Best matching control group by least sum of squares}
\usage{
match_control_group(nipt_sample, nipt_control_group, mode, n_of_samples,
  include_chromosomes = NULL, exclude_chromosomes = NULL)
}
\arguments{
\item{nipt_sample}{The NIPTSample object that is the focus of the analysis}

\item{nipt_control_group}{The NIPTControlGroup object used in the analysis}

\item{mode}{The function mode. This can either be \emph{"subset"} or \emph{"report"}.
Mode \emph{"subset"} means the return value will be a new `NIPTControlGroup` object containing  \emph{n}
samples. When mode \emph{"report"} is used the output is a matrix containing the sum of squares score 
of the differences between the chromosomal fractions of the sample and the control for every control 
sample, sorted in increasing score.}

\item{n_of_samples}{The length of the resulting NIPTControlGroup. Only applicable if mode \emph{"subset"} is used.}

\item{include_chromosomes}{integer. Include potential trisomic chromosomes into the comparison? Default = NULL,
meaning chromosomes 13, 18 and 21 are not included}

\item{exclude_chromosomes}{integer.Exclude other autosomal chromosomes besides chromosomes 
13, 18 and 21? Default = NULL}
}
\value{
The output for mode \emph{subset} is a new `NIPTControlGroup` composed of _n_ samples. 
The output for mode \emph{report} is a matrix with a single column containing the sum of squares
in ascending order.
}
\description{
The matchcontrolgroup function determines how well an NIPTSample fits within the NIPTControlGroup
}
\details{
The `matchcontrolgroup` function determines how well an NIPTSample fits within the NIPTControlGroup
and, if needed, makes a subset `NIPTControlGroup` of length \emph{n}.
}

