% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-original-bipartite.R
\name{plotBipartite}
\alias{plotBipartite}
\title{Plot the graph based on input data}
\usage{
plotBipartite(
  inc_mat,
  dim = 0,
  verbose = FALSE,
  vertex.label.display = FALSE,
  layout = layout.bipartite,
  vertex.shape = c("square", "circle"),
  vertix.color = c("steel blue", "orange"),
  vertex.label.cex = 0.3,
  vertex.size = 4,
  edge.width = 0.4,
  edge.color = "pink"
)
}
\arguments{
\item{inc_mat}{A matrix, the incidence matrix of graph.}

\item{dim}{An integer value, chosen between plotting the original bipartite
graph or its projection. Default is 0 which plot the original bipartite
graph. other options: 1, 2}

\item{verbose}{A logical, if TRUE, the plot is saved as the .png file in the
working directory. Default is FALSE.}

\item{vertex.label.display}{A Boolean var, if TRUE then show the label of
each vertex. Default is FALSE.}

\item{layout}{A function from igraph package, plot layout. Default is
layout.bipartite, thus the nodes on the top side are the variables in rows,
nodes on the bottom side are those in columns.}

\item{vertex.shape}{A vector, shapes for two different sets of vertices.
Default is c("square", "circle"), the first one is for the nodes in rows,
the second one is for nodes in columns, if the \code{dim} is not 0, then
only the first one will be used.}

\item{vertix.color}{A vector, colors for two different sets of vertices.
Default is c("steel blue", "orange"), the first one is for the nodes in
rows, the second one is for nodes in columns, if the \code{dim} is not 0,
then only the first one will be used..}

\item{vertex.label.cex}{A numeric, vertex labels' size. Default is 0.3.}

\item{vertex.size}{A numeric, vertex size. Default is 4.}

\item{edge.width}{A numeric, edge width. Default is 0.1.}

\item{edge.color}{A string, edge color. Default is pink.}
}
\value{
An igraph graph object.
}
\description{
This function converts the input incidence matrix into a
bipartite graph, and uses the igraph package to draw an figure.
}
\examples{
# load part of the beatAML data
beatAML_data <- NIMAA::beatAML[1:1000,]

# plot beatAML data and convert to incidence matrix
beatAML_incidence_matrix <- el2IncMatrix(beatAML_data, print_skim = FALSE)

# plot with the vertex label showing
plotBipartite(inc_mat = beatAML_incidence_matrix, vertex.label.display = TRUE)
}
