% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{chmNewCovariateBar}
\alias{chmNewCovariateBar}
\title{Create a new covariate Bar for a NGCHM}
\usage{
chmNewCovariateBar(
  covar,
  display = "visible",
  thickness = as.integer(10),
  merge,
  barType,
  loBound,
  hiBound,
  fgColor,
  bgColor
)
}
\arguments{
\item{covar}{The covariate to be displayed in the bar.}

\item{display}{Whether the covariate bar will be "hidden" or "visible" (default).}

\item{thickness}{The thickness of the covariate bar in pixels. (Default 10).}

\item{merge}{Algorithm for merging covariates when necessary ("average", "peakColor", "specialColor", or "mostCommon").}

\item{barType}{Type of covariate bar ("color_plot", "scatter_plot", "bar_plot"). Default "color_plot".}

\item{loBound}{Low bound for bar and scatter plots. Default minimum data value.}

\item{hiBound}{High bound for bar and scatter plots.  Default maximum data value.}

\item{fgColor}{Foreground color for bar and scatter plots.  Default black.}

\item{bgColor}{Background color for bar and scatter plots.  Default white.}
}
\value{
An object of class ngchmBar
}
\description{
This function creates a new covariate bar suitable for adding to a Next Generation Clustered Heat Map.
}
\examples{
bar.data <- ifelse(rnorm(1000) < 0, "negative", "non-negative")
names(bar.data) <- sprintf("Sample\%d", 1:length(bar.data))
bar.colors <- chmNewColorMap(c("negative", "non-negative"),
  c("white", "black"),
  missing.color = "red"
)
covar <- chmNewCovariate("Group", bar.data, bar.colors, "discrete")
bar <- chmNewCovariateBar(covar)

}
\seealso{
\linkS4class{ngchmBar}

\code{\link[=chmNewColorMap]{chmNewColorMap()}}

\code{\link[=chmAddCovariateBar]{chmAddCovariateBar()}}
}
