% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{chmRegisterTypeMapper}
\alias{chmRegisterTypeMapper}
\title{Register a predefined Javascript function for converting values from
one type to another.}
\usage{
chmRegisterTypeMapper(fromtype, totype, op, ...)
}
\arguments{
\item{fromtype}{The type of values the function expects as input.}

\item{totype}{The type of values the function will produce.  The length of
totype must be shorter than fromtype.}

\item{op}{The operation code for performing the conversion}

\item{...}{Additional parameters required for specifying the conversion (op specific)}
}
\value{
NULL

op can have the following values:
\itemize{
\item 'field' Split source into fields separated by 'separator' and select field 'num' (0 origin)
\item 'expr' Compute string expression 'expr'. 'return' value is a vector or a scalar (default)
\item 'javascript' Evaluate javascript function 'fn' (deprecated)
}
}
\description{
This function registers a Javascript function that will be automatically
added to a Next Generation Clustered Heat Map as required for converting
values from one type into another more basic type.
This function is intended for use by NGCHM system developers.
}
\seealso{
\code{\link[=chmAddAxisType]{chmAddAxisType()}}

\code{\link[=chmRegisterAxisFunction]{chmRegisterAxisFunction()}}

\code{\link[=chmRegisterMatrixFunction]{chmRegisterMatrixFunction()}}

\code{\link[=chmNewFunction]{chmNewFunction()}}
}
