% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_passes_rushes_strategy.R
\name{sample_passes_rushes_strategy}
\alias{sample_passes_rushes_strategy}
\title{Sample NFL play-by-play data with a specified blend of rushing and passing}
\usage{
sample_passes_rushes_strategy(
  what_down,
  yards_to_go,
  yards_from_own_goal,
  window_yards_from_own_goal = 1,
  play_by_play_data,
  prop_passes = 0.5
)
}
\arguments{
\item{what_down}{The current down (1st, 2nd, 3rd, or 4th down)}

\item{yards_to_go}{Number of yards to go until a first down or TD}

\item{yards_from_own_goal}{The number of yards from the possession team's own goal}

\item{window_yards_from_own_goal}{Precision parameter for "yards_from_own_goal" (a value of 1 means the sampling
will occur within plus or minus 1 of the "yards_from_own_goal" value)}

\item{play_by_play_data}{A data file from nflscrapR prepped using the prep_pbp_data.R function}

\item{prop_passes}{Proportion of plays that should be pass plays, between 0 and 1, inclusive}
}
\value{
A tibble containing lots of info
}
\description{
This function will return a sample play from the nflscrapR play-by-play
data for a given down, distance, yards from the team's goal, using
a given pass/rush play strategy. The user may choose a value for the 
proportion of passing plays to be sampled. Thus one can test strategies
in which the team always passes, always runs, or some distribution of the two.
This strategy is only intended for downs 1 - 3, and uses an empirical strategy 
for fourth downs.
This should be primarily used within the `NFLSimulatoR::sample_play()` function.
}
\examples{
\dontrun{
sample_passes_rushes_strategy(what_down = 3,
                              yards_to_go = 2,
                              yards_from_own_goal = 45,
                              window_yards_from_own_goal = 2,
                              play_by_play_data = reg_pbp_2018,
                              prop_passes = 0.5)
}
}
