% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NBBDesigns.R
\name{nbbd1}
\alias{nbbd1}
\title{NBB Design  of Type 1 (NBBD 1)}
\usage{
nbbd1(v)
}
\arguments{
\item{v}{Number of treatments (a prime number)}
}
\value{
It generates neighbour balanced blocks designs for a given number of treatments (v>3), when v is prime number.
}
\description{
When v(>3) is a prime number (prime number is a number which is divisible by itself and by 1) then it will generate a class of neighbour balanced block designs. This class of design is generated using the method of constructing Type 3 designs of (Azais, 1993). It also gives the parameters of the design, information matrix for estimating the contrast pertaining to direct and neighbour effects (both left and right) of the treatments.
}
\examples{
library(NBBDesigns)
nbbd1(5)

}
\references{
(i) Azais, J.M. (1987)<DOI: 10.1111/j.2517-6161.1987.tb01704.x>."Design of experiments for studying intergenotypic competition";
(ii) Azais, J.M., Bailey, R.A. and Monod, H. (1993)<DOI: 10.2307/2532269>."A catalogue of efficient neighbour designs with border plots";
(iii) Rees, D. H. (1967)<DOI: 10.2307/2528428>."Some designs of use in serology";
}
