% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NB.MClust.R
\name{NB.MClust}
\alias{NB.MClust}
\title{NB.MClust Function}
\usage{
NB.MClust(Count, K, ini.shift.mu = 0.01, ini.shift.theta = 0.01,
  tau0 = 10, rate = 0.9, bic = TRUE, iteration = 50)
}
\arguments{
\item{Count}{Data matrix of discrete counts.This function groups rows of the data matrix.}

\item{K}{Number of clusters or components specified. It can be a positive integer or a vector of positive integer.}

\item{ini.shift.mu}{Initial value in EM algorithm for the shift between clusters in mean.}

\item{ini.shift.theta}{Initial value in EM algorithm for the shift between clusters in dispersion.}

\item{tau0}{Initial value of anealing rates in EM Algorithm. Default and suggested value is 10.}

\item{rate}{Stochastic decreasing speed for anealing rate. Default and suggested value is 0.9}

\item{bic}{Whether Bayesian Information should be computed when K is an integer. BIC is forced to be TRUE when K is a vector.}

\item{iteration}{Maximum number of iterations in EM Algorithm, default at 50.}
}
\value{
\item{parameters}{Estimated parameters}

          \item{$prior}{Prior probability that a sample belongs to each cluster}               
          \item{$mu}{Mean of each cluster} 
          \item{$theta}{Dispersion of each cluster} 
          \item{$posterior}{Posterior probability that a sample belongs to each cluster}
         
         \item{cluster}{Estimated cluster assignment} 
         
         \item{BIC}{Value of Bayesian Information} 
         
         \item{K}{Optional or estimated number of clusters, if input K is a vector}
}
\description{
This function performs model-based clustering on positive integer or continuous data that follow Generalized Negative Binomial distribution.
}
\examples{
# Example:

data("Simulated_Count") # A 50x100 integer data frame.

m1=NB.MClust(Simulated_Count,K=2:5)
cluster=m1$cluster #Estimated cluster assignment
k_hat=m1$K  #Estimated optimal K

}
\keyword{NB.MClust}
