% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autotune_VIM_Irmi.R
\name{autotune_VIM_Irmi}
\alias{autotune_VIM_Irmi}
\title{Perform imputation using VIM package and irmi function}
\usage{
autotune_VIM_Irmi(
  df,
  col_type = NULL,
  percent_of_missing = NULL,
  eps = 5,
  maxit = 100,
  step = FALSE,
  robust = FALSE,
  init.method = "kNN",
  force = FALSE,
  col_0_1 = FALSE,
  out_file = NULL
)
}
\arguments{
\item{df}{data.frame. Df to impute with column names and without target column.}

\item{col_type}{character vector. Vector containing column type names.}

\item{percent_of_missing}{numeric vector. Vector contatining percent of missing data in columns for example  c(0,1,0,0,11.3,..)}

\item{eps}{threshold for convergency}

\item{maxit}{maximum number of iterations}

\item{step}{stepwise model selection is applied when the parameter is set to TRUE}

\item{robust}{if TRUE, robust regression methods will be applied (it's impossible to set step=TRUE and robust=TRUE at the same time)}

\item{init.method}{Method for initialization of missing values (kNN or median)}

\item{force}{if TRUE, the algorithm tries to find a solution in any case, possible by using different robust methods automatically. (should be set FALSE for simulation)}

\item{col_0_1}{Decaid if add bonus column informing where imputation been done. 0 - value was in dataset, 1 - value was imputed. Default False. (Works only for returning one dataset).}

\item{out_file}{Output log file location if file already exists log message will be added. If NULL no log will be produced.}
}
\value{
Return one data.frame with imputed values.
}
\description{
Function use IRMI (Iterative robust model-based imputation ) to impute missing data.
}
\details{
Function can work with various different times depending on data size and structure. In some cases when selected param wouldn't work function try to run on default.  Most important param for both quality and reliability  its eps.
}
\examples{
{
  raw_data <- data.frame(
    a = as.factor(sample(c("red", "yellow", "blue", NA), 1000, replace = TRUE)),
    b = as.integer(1:1000),
    c = as.factor(sample(c("YES", "NO", NA), 1000, replace = TRUE)),
    d = runif(1000, 1, 10),
    e = as.factor(sample(c("YES", "NO"), 1000, replace = TRUE)),
    f = as.factor(sample(c("male", "female", "trans", "other", NA), 1000, replace = TRUE)))

  # Prepering col_type
  col_type <- c("factor", "integer", "factor", "numeric", "factor", "factor")

  percent_of_missing <- 1:6
  for (i in percent_of_missing) {
    percent_of_missing[i] <- 100 * (sum(is.na(raw_data[, i])) / nrow(raw_data))
  }


  imp_data <- autotune_VIM_Irmi(raw_data, col_type, percent_of_missing)

  # Check if all missing value was imputed
  sum(is.na(imp_data)) == 0
  # TRUE
}

}
\references{
{  Alexander Kowarik, Matthias Templ (2016). Imputation with the R Package VIM. Journal of Statistical Software, 74(7), 1-16. doi:10.18637/jss.v074.i07}
}
\author{
{ Alexander Kowarik, Matthias Templ (2016) \doi{10.18637/jss.v074.i07}}
}
