% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cen_ecdf.R
\name{cen_ecdf}
\alias{cen_ecdf}
\title{Censored Empirical Cumulative Distribution Function}
\usage{
cen_ecdf(y.var, cen.var, group = NULL, xlim = c(0, max(y.var)), Ylab = varname)
}
\arguments{
\item{y.var}{The column of data values plus detection limits}

\item{cen.var}{The column of indicators, where 1 (or \code{TRUE}) indicates a detection limit in the \code{y.var} column, and 0 (or \code{FALSE}) indicates a detected value in \code{y.var}.}

\item{group}{Optional - grouping or factor variable. Can be either a text or numeric value indicating the group assignment.}

\item{xlim}{Limits for the x (data) axis of the ecdf plot.  Default is 0 to the maximum of the y.var variable.  To change, use option xlim = c(0, 50) if 50 is to be the maximum on the plot.}

\item{Ylab}{Optional – input text in quotes to be used as the variable name on the ecdf plot.  The default is the name of the \code{y.var} input variable.}
}
\value{
Plots an empirical cumulative distribution function. If \code{group=NULL} the ECDF of the entire dataset is produced. If \code{group} is identified then ECDFs are plotted for each group seperately and a legend added.
}
\description{
Plots ecdfs of one or more groups of censored data.  Illustrates the differences between groups for group tests such as those done using cen1way or cenanova.
}
\examples{
data(PbHeron)

# with groups
with(PbHeron, cen_ecdf(Liver, LiverCen, DosageGroup))

# all data
with(PbHeron, cen_ecdf(Liver, LiverCen))
}
\references{
Helsel, D.R., 2011. Statistics for Censored Environmental Data using Minitab and R, 2nd ed. John Wiley & Sons, USA, N.J.
Millard, S.P., 2013. EnvStats: An R Package for Environmental Statistics. Springer-Verlag, New York.
}
\keyword{CDF}
\keyword{ECDF}
