/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity.file;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.similarity.GenericItemSimilarity;
import org.apache.mahout.cf.taste.impl.similarity.file.FileItemItemSimilarityIterable;
import org.apache.mahout.cf.taste.similarity.ItemSimilarity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileItemSimilarity
implements ItemSimilarity {
    public static final long DEFAULT_MIN_RELOAD_INTERVAL_MS = 60000L;
    private ItemSimilarity delegate;
    private final ReentrantLock reloadLock;
    private final File dataFile;
    private long lastModified;
    private final long minReloadIntervalMS;
    private static final Logger log = LoggerFactory.getLogger(FileItemSimilarity.class);

    public FileItemSimilarity(File dataFile) {
        this(dataFile, 60000L);
    }

    public FileItemSimilarity(File dataFile, long minReloadIntervalMS) {
        Preconditions.checkArgument(dataFile != null, "dataFile is null");
        Preconditions.checkArgument(dataFile.exists() && !dataFile.isDirectory(), "dataFile is missing or a directory: %s", dataFile);
        log.info("Creating FileItemSimilarity for file {}", (Object)dataFile);
        this.dataFile = dataFile.getAbsoluteFile();
        this.lastModified = dataFile.lastModified();
        this.minReloadIntervalMS = minReloadIntervalMS;
        this.reloadLock = new ReentrantLock();
        this.reload();
    }

    @Override
    public double[] itemSimilarities(long itemID1, long[] itemID2s) throws TasteException {
        return this.delegate.itemSimilarities(itemID1, itemID2s);
    }

    @Override
    public long[] allSimilarItemIDs(long itemID) throws TasteException {
        return this.delegate.allSimilarItemIDs(itemID);
    }

    @Override
    public double itemSimilarity(long itemID1, long itemID2) throws TasteException {
        return this.delegate.itemSimilarity(itemID1, itemID2);
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        if (this.dataFile.lastModified() > this.lastModified + this.minReloadIntervalMS) {
            log.debug("File has changed; reloading...");
            this.reload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reload() {
        if (this.reloadLock.tryLock()) {
            try {
                long newLastModified = this.dataFile.lastModified();
                this.delegate = new GenericItemSimilarity(new FileItemItemSimilarityIterable(this.dataFile));
                this.lastModified = newLastModified;
            }
            finally {
                this.reloadLock.unlock();
            }
        }
    }

    public String toString() {
        return "FileItemSimilarity[dataFile:" + this.dataFile + ']';
    }
}

