/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.pseudo;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.hadoop.RecommendedItemsWritable;
import org.apache.mahout.cf.taste.hadoop.pseudo.ReducerMetrics;
import org.apache.mahout.cf.taste.impl.model.file.FileDataModel;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Recommender;
import org.apache.mahout.math.VarLongWritable;

public final class RecommenderReducer
extends Reducer<VarLongWritable, NullWritable, VarLongWritable, RecommendedItemsWritable> {
    static final String RECOMMENDER_CLASS_NAME = "recommenderClassName";
    static final String RECOMMENDATIONS_PER_USER = "recommendationsPerUser";
    static final String DATA_MODEL_FILE = "dataModelFile";
    private Recommender recommender;
    private int recommendationsPerUser;

    protected void setup(Reducer.Context context) throws IOException {
        Configuration jobConf = context.getConfiguration();
        String dataModelFile = jobConf.get(DATA_MODEL_FILE);
        String recommenderClassName = jobConf.get(RECOMMENDER_CLASS_NAME);
        Path dataModelPath = new Path(dataModelFile);
        FileSystem fs = FileSystem.get((URI)dataModelPath.toUri(), (Configuration)jobConf);
        File tempDataFile = File.createTempFile("mahout-taste-hadoop", "txt");
        tempDataFile.deleteOnExit();
        fs.copyToLocalFile(dataModelPath, new Path(tempDataFile.getAbsolutePath()));
        FileDataModel fileDataModel = new FileDataModel(tempDataFile);
        try {
            Class<Recommender> recommenderClass = Class.forName(recommenderClassName).asSubclass(Recommender.class);
            Constructor<Recommender> constructor = recommenderClass.getConstructor(DataModel.class);
            this.recommender = constructor.newInstance(fileDataModel);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalStateException(nsme);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException(cnfe);
        }
        catch (InstantiationException ie) {
            throw new IllegalStateException(ie);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalStateException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new IllegalStateException(ite.getCause());
        }
        this.recommendationsPerUser = jobConf.getInt(RECOMMENDATIONS_PER_USER, 10);
    }

    protected void reduce(VarLongWritable key, Iterable<NullWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        List<RecommendedItem> recommendedItems;
        long userID = key.get();
        try {
            recommendedItems = this.recommender.recommend(userID, this.recommendationsPerUser);
        }
        catch (TasteException te) {
            throw new IllegalStateException(te);
        }
        Iterator<RecommendedItem> it = recommendedItems.iterator();
        while (it.hasNext()) {
            if (!Float.isNaN(it.next().getValue())) continue;
            it.remove();
        }
        RecommendedItemsWritable writable = new RecommendedItemsWritable(recommendedItems);
        context.write((Object)key, (Object)writable);
        context.getCounter((Enum)ReducerMetrics.USERS_PROCESSED).increment(1L);
        context.getCounter((Enum)ReducerMetrics.RECOMMENDATIONS_MADE).increment((long)recommendedItems.size());
    }
}

