% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.sde.r
\name{sde.method}
\alias{sde.method}
\title{Performs a Single Dimension Exploration (SDE) analysis in the
given multigroup data matrix.
Show SDE graphical output.}
\usage{
sde.method(mydata, groups, plt = FALSE)
}
\arguments{
\item{mydata}{data set}

\item{groups}{is a vector of classes}

\item{plt}{grafics}
}
\value{
\strong{return an grafics} .
}
\description{
Performs a Single Dimension Exploration (SDE) analysis in the
given multigroup data matrix.
Show SDE graphical output.
}
\examples{
sim.list2<-fun.sim(g=c(20,50,10),mean1=0.5,d=0,sds2=c(1,1,1,1),corr=c(0.1,0.5,0.5,0),
n.var=c(20,20))
datos2 <- as.data.frame(sim.list2$x)
datos2<-subset(datos2,select=-grp)
grupos <- sim.list2$grp
grupos<-factor(grupos,labels=c(1,2,3))
sde.method(mydata=datos2,groups=grupos,plt=FALSE)
}
