% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InputsForOpt.R
\name{FeedMat_Q}
\alias{FeedMat_Q}
\title{Get an estimate for the risk-neutral (Q) feedback matrix}
\usage{
FeedMat_Q(
  Yields,
  Spa_Fac,
  Economies,
  UnitYields,
  time_step,
  check_inputs = TRUE
)
}
\arguments{
\item{Yields}{matrix of bond yields (J x T)}

\item{Spa_Fac}{matrix of spanned factors  (N x T)}

\item{Economies}{string-vector containing the names of the economies which are part of the economic system}

\item{UnitYields}{(i) "Month": if maturity of yields are expressed in months or
(ii) "Year": if maturity of yields are expressed in years}

\item{time_step}{time unit of the model (scalar). For instance, if data is (i) monthly, dt <- 12; (ii) quarterly, dt <- 4; (iii) yearly, dt <- 1.}

\item{check_inputs}{Perform input validation. Default is TRUE.}
}
\description{
Get an estimate for the risk-neutral (Q) feedback matrix
}
\references{
Le, A., & Singleton, K. J. (2018). Small Package of Matlab Routines for
Estimation of Some Term Structure Models. EABCN Training School.\cr
This function offers an independent R implementation that is informed
by the conceptual framework outlined in Le and Singleton (2018), but adapted to the
present modeling context.
}
\keyword{internal}
