% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VAR.R
\name{Reg__OLSconstrained}
\alias{Reg__OLSconstrained}
\title{Restricted OLS regression}
\usage{
Reg__OLSconstrained(Y, X, Bcon, G = NULL)
}
\arguments{
\item{Y}{left hand side variables (M x T)}

\item{X}{regressors (i.e. N-1 variables + the intercept) (N x T)}

\item{Bcon}{constraints matrix (M x N). If Bcon(i,j) = nan --> B(i,j) is a free parameter}

\item{G}{weighting matrix (psd) - (M x M). Default is set to be identity}
}
\value{
matrix of coefficient (M x N)
}
\description{
Restricted OLS regression
}
\details{
Estimate of B is obtained by minimizing the objective:
  sum_t (Y_t-B X_t)' G^(-1) (Y_t-B*X_t)
subject to the constraint that B = Bcon for all non-nan entries of Bcon
}
\references{
This function is based on the "Reg__OLSconstrained" function by Le and Singleton (2018).
 "A Small Package of Matlab Routines for the Estimation of Some Term Structure Models."
 (Euro Area Business Cycle Network Training School - Term Structure Modelling).
Available at: https://cepr.org/40029
}
\keyword{internal}
