% Generated by roxygen2 (4.0.1): do not edit by hand
\name{findWeiszfeldMedian}
\alias{findWeiszfeldMedian}
\title{Find M-posterior using samples from subset posteriors}
\usage{
findWeiszfeldMedian(subsetAtomsList, sigma = 0.1, maxit = 100,
  tol = 1e-10)
}
\arguments{
\item{subsetAtomsList}{list of samples from subset posteriors; each element of the list must be a matrix}

\item{sigma}{parameter of RBF kernel with form exp(- sigma || x - y ||^2)}

\item{maxit}{maximum number of iterations estimating M-posterior}

\item{tol}{tolerance for declaring convergence of Weiszfeld algorithm}
}
\value{
list containing Weiszfeld wts of subset posteriors, M-posterior atoms, and the estimation set-up
}
\description{
Find M-posterior given list of samples from subset posteriors using Weiszfeld algorithm of Minsker et al. (2014).
}
\details{
Samples from subset posteriors are represented as matrices, with
the rows representing atoms and the columns indexing
dimensions. Length of \code{subsetAtomsList} equals the number of
subsets (and posteriors). M-posterior estimates the weights of its
atoms given the atoms of subset posteriors using Weiszfeld algorithm
as implemented in \code{findWeiszfeldMedian}; \code{sigma} controls the
sensitivity of distance between subset posteriors.
}
\examples{
set.seed(12345)
## list that contains subset posterior samples from 2-dim Gaussian density
subAtomList <- vector("list", 5)
subAtomList[[1]] <- cbind(rnorm(100, mean = 1),  rnorm(100, mean = 1))
subAtomList[[2]] <- cbind(rnorm(100, mean = -1),  rnorm(100, mean= -1))
subAtomList[[3]] <- cbind(rnorm(100, mean = -1),  rnorm(100, mean = 1))
subAtomList[[4]] <- cbind(rnorm(100, mean = 1),  rnorm(100, mean = -1))
subAtomList[[5]] <- cbind(rnorm(100, mean = 2),  rnorm(100, mean = 2))
library(Mposterior)
medPosterior <- findWeiszfeldMedian(subAtomList, sigma = 0.1, maxit = 100, tol = 1e-10)
medPosterior
summary(medPosterior)
plot(medPosterior)
}
\author{
Sanvesh Srivastava \email{sanvesh@gmail.com}
}
\references{
Minsker, S., Srivastava, S., Lin, L., and Dunson, D.B. (2014). Robust and Scalable Bayes via a Median of Subset Posterior Measures. \url{http://arxiv.org/abs/1403.2660}
}

