% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{LatexSummaryTable}
\alias{LatexSummaryTable}
\title{Display summary table of Mplus model statistics in separate window}
\usage{
LatexSummaryTable(modelList, keepCols, dropCols, sortBy, label = NULL,
  caption = NULL)
}
\arguments{
\item{modelList}{A list of models (as a \code{data.frame}) returned from the \code{extractModelSummaries} function.}

\item{keepCols}{A vector of character strings indicating which columns/variables to display in the summary. Only columns
included in this list will be displayed (all others excluded). By default, \code{keepCols}
is: \code{c("Title", "LL", "Parameters", "AIC", "AICC", "BIC", "RMSEA_Estimate")}.
Example: \code{c("Title", "LL", "AIC", "CFI")}}

\item{dropCols}{A vector of character strings indicating which columns/variables to omit from the summary.
Any column not included in this list will be displayed. By default, \code{dropCols} is \code{NULL}.
Example: \code{c("InputInstructions", "TLI")}}

\item{sortBy}{optional. Field name (as character string) by which to sort the table.
Typically an information criterion (e.g., "AIC" or "BIC") is used to sort the table. Defaults to "AICC"}

\item{label}{optional. A character string specifying the label for the LaTex table, which can be
used for referencing the table.}

\item{caption}{optional. A character string specifying the caption for the LaTex table.}
}
\value{
A LaTex-formatted table summarizing the \code{modelList} is returned (created by \code{xtable}).
}
\description{
Creates a LaTex-formatted summary table of model fit statistics extracted using the \code{extractModelSummaries} function.
The table syntax is returned by the function, which is useful for embedding LaTex tables using Sweave.
By default, the following summary statistics are included: \code{Title, LL, Parameters, AIC, AICC, BIC, RMSEA_Estimate},
but these are customizable using the \code{keepCols} and \code{dropCols} parameters.
}
\note{
You must choose between \code{keepCols} and \code{dropCols} because it is not sensible to use these together
  to include and exclude columns. The function will error if you include both parameters.
}
\examples{
# make me!!!
}
\seealso{
\code{\link{extractModelSummaries}}, \code{\link{HTMLSummaryTable}}, \code{\link{showSummaryTable}}, \code{\link{Sweave}}
}
\author{
Michael Hallquist
}
\keyword{interface}
