% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pensionTable.R
\docType{class}
\name{pensionTable-class}
\alias{pensionTable-class}
\alias{pensionTable}
\title{Class pensionTable}
\description{
Class \code{pensionTable} is the (virtual) base class for all pensions
tables. It contains the name and some general values applying to all
types of tables. In particular, it holds individual tables for each of the
transition probabilities. Possible states are:
\itemize{
    \item active: healty, no pension, typically paying some kin of premium
    \item incapacity: disablity pension, in most cases permanent, not working, early pension
    \item retirement: old age pension, usually starting with a fixed age
    \item dead \itemize{
      \item Widow/widower pension
    }
}
Correspondingly, the following transition probabilities can be given:\describe{
    \item{qxaa}{death probability of actives (active -> dead)}
    \item{ix}{invalidity probability (active -> incapacity)}
    \item{qix}{death probability of invalid (invalid -> dead)}
    \item{rx}{reactivation probability (incapacity -> active)}
    \item{apx}{retirement probability (active -> retirement), typically 1 for a fixed age}
    \item{qpx}{death probability of retired (retired -> dead)}
    \item{hx}{probability of a widow at moment of death (dead -> widow), y(x) age difference}
    \item{qxw}{death probability of widows/widowers}
    \item{qgx}{death probability of total group (irrespective of state)}
    \item{invalids.retire}{Flag to indicate whether invalid persons retire
          like active (one death probability for all retirees) or whether
          they stay invalid until death with death probabilities specific to
          invalids.}
}
}
\section{Slots}{

\describe{
\item{\code{qx}}{Death probability table of actives (derived from mortalityTable)}

\item{\code{ix}}{Invalidity probability of actives (derived from mortalityTable)}

\item{\code{qix}}{Death probability table of invalids (derived from mortalityTable)}

\item{\code{rx}}{Reactivation probability of invalids (derived from mortalityTable)}

\item{\code{apx}}{Retirement probability of actives (derived from mortalityTable)}

\item{\code{qpx}}{Death probability of old age pensioners (derived from mortalityTable)}

\item{\code{hx}}{Probability of a widow at the moment of death (derived from mortalityTable)}

\item{\code{qwy}}{Death probability of widow(er)s (derived from mortality Table)}

\item{\code{yx}}{Age difference of the widow to the deceased}

\item{\code{qgx}}{Death probability of whole group (derived from mortalityTable), irrespective of state}

\item{\code{invalids.retire}}{Whether invalids retire like actives or stay invalid until death}

\item{\code{probs.arrange}}{A function that takes the individual transition probabilities of all the components and creates one object (a data.frame or a list) that will be returned by the method \code{transitionProbabilities}. The default arranges all tables without further modification. However, some pension tables (like the german Heubeck table) require the total mortality to be recalculated from the individual mortalities of actives and disabled. In this case, the function assigned to this slot will also calculate that total probability.}
}}

