% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-ldk-utilities.R
\name{get_ldk}
\alias{get_ldk}
\title{Retrieves landmarks coordinates}
\usage{
get_ldk(Coo)
}
\arguments{
\item{Coo}{an Out, Opn or Ldk object}
}
\value{
a list of shapes
}
\description{
See Details for the different behaviors implemented.
}
\details{
Different behaviors depending on the class of the object:
\itemize{
\item \link{Ldk}: retrieves landmarks.
\item Ldk with slidings defined: retrieves only the fixed landmarks, not the sliding ones.
See also \link{get_slidings}.
\item \link{Out} landmarks from \code{$ldk} and \code{$coo}, if any.
\item \link{Opn}: same as above.
}
}
\examples{
# Out example
ldk.h <- get_ldk(hearts)
stack(Ldk(ldk.h))

# on Ldk (no slidings)
get_ldk(wings) # equivalent to wings$coo

# on Ldk (slidings)
get_ldk(chaff)
get_ldk(chaff) \%>\% Ldk \%>\% fgProcrustes(tol=0.1) \%>\% stack
}
\seealso{
Other ldk/slidings methods: 
\code{\link{add_ldk}()},
\code{\link{def_ldk}()},
\code{\link{def_slidings}()},
\code{\link{get_slidings}()},
\code{\link{rearrange_ldk}()},
\code{\link{slidings_scheme}()}
}
\concept{ldk/slidings methods}
