% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babel-import.R
\name{lf_structure}
\alias{lf_structure}
\title{bind_db.Coe <- bind_db.Coo
Extracts structure from filenames}
\usage{
lf_structure(lf, names = character(), split = "_", trim.extension = FALSE)
}
\arguments{
\item{lf}{a list (its names are used, except if it is a list from \link{import_tps}
in this case \code{names(lf$coo)} is used) of a list of filenames, as characters, typically such as
those obtained with \link{list.files}. Alternatively, a path to a folder
containing the files. Actually, if lf is of length 1 (a single character),
the function assumes it is a path and do a \link{list.files} on it.}

\item{names}{the names of the groups, as a vector of characters which length corresponds
to the number of groups.}

\item{split}{character, the spliting factor used for the file names.}

\item{trim.extension}{logical. Whether to remove the last for characters in
filenames, typically their extension, e.g. '.jpg'.}
}
\value{
data.frame with, for every individual, the corresponding level
for every group.
}
\description{
If filenames are consistently named with the same character serating factors,
and with every individual including its belonging levels, e.g.:
\itemize{
\item \code{001_speciesI_siteA_ind1_dorsalview}
\item \code{002_speciesI_siteA_ind2_lateralview} } etc., this function returns a \link{data.frame}
from it that can be passed to \link{Out}, {Opn}, {Ldk} objects.
}
\details{
The number of groups must be consistent accross filenames.
}
\note{
This is, to my view, a good practice to 'store' the grouping structure
in filenames, but it is of course not mandatory.

Note also that you can: i) do a \link{import_jpg} and save is a list, say 'foo';
then ii) pass 'names(foo)' to lf_structure. See Momocs' vignette for an illustration.

Note this function will be deprecated from Momocs
when \code{Momacs} and \code{Momit}
will be fully operationnal.
}
\seealso{
\link{import_jpg1}, \link{import_Conte}, \link{import_txt}, \link{lf_structure}.
See also Momocs' vignettes for data import.

Other babel functions: \code{\link{tie_jpg_txt}}
}
