% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-opn-polynomials.R
\name{opoly}
\alias{opoly}
\alias{opoly.default}
\alias{opoly.Opn}
\title{Calculate orthogonal polynomial fits on open outlines}
\usage{
opoly(x, ...)

\method{opoly}{default}(x, degree, ...)

\method{opoly}{Opn}(x, degree, baseline1 = c(-0.5, 0), baseline2 = c(0.5,
  0), nb.pts = 120, ...)
}
\arguments{
\item{x}{a matrix (or a list) of (x; y) coordinates}

\item{...}{useless here}

\item{degree}{polynomial degree for the fit (the Intercept is also returned)}

\item{baseline1}{numeric the \eqn{(x; y)} coordinates of the first baseline
by default \eqn{(x= -0.5; y=0)}}

\item{baseline2}{numeric the \eqn{(x; y)} coordinates of the second baseline
by default \eqn{(x= 0.5; y=0)}}

\item{nb.pts}{number of points to sample and on which to calculate polynomials}
}
\value{
a list with components when applied on a single shape:
\itemize{
 \item \code{coeff} the coefficients (including the intercept)
 \item \code{ortho} whether orthogonal or natural polynomials were fitted
 \item \code{degree} degree of the fit (could be retrieved through \code{coeff} though)
 \item \code{baseline1} the first baseline point (so far the first point)
 \item \code{baseline2} the second baseline point (so far the last point)
 \item \code{r2} the r2 from the fit
 \item \code{mod} the raw lm model
}
otherwise an \link{OpnCoe} object.
}
\description{
Calculates orthogonal polynomial coefficients,
through a linear model fit (see \link{lm}), from a matrix of (x; y) coordinates or
a \link{Opn} object
}
\note{
Orthogonal polynomials are sometimes called Legendre's polynomials. They are
preferred over natural polynomials since adding a degree do not change lower orders coefficients.
}
\examples{
data(olea)
o <- olea[1]
op <- opoly(o, degree=4)
op
# shape reconstruction
opi <- opoly_i(op)
lines(opi, col='red')
# R2 for degree 1 to 10
r <- numeric()
for (i in 1:10) { r[i] <- opoly(o, degree=i)$r2 }
plot(2:10, r[2:10], type='b', pch=20, col='red', main='R2 / degree')
}
\seealso{
Other polynomials: \code{\link{npoly}},
  \code{\link{opoly_i}}
}
