% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{my.confidence.region}
\alias{my.confidence.region}
\title{Ellipse ou intervalles de confiance pour une paire de paramètres d'un modèle linéaire}
\usage{
my.confidence.region(g, a = 2, b = 3, which = 0, col = "pink")
}
\arguments{
\item{g}{Modele linéaire}

\item{a}{Premier paramètre de l'ellipse}

\item{b}{Second paramtère de l'ellipse}

\item{which}{Type de région de confiance : 1 (ellipse autour des deux paramètres), 2 (rectangle autour du premier paramètre, axe des x) et 3 (rectangle autour du second paramètre, axes des y)}

\item{col}{Couleur de remplissage de la région de confiance}
}
\description{
Ellipse ou intervalles de confiance pour une paire de paramètres d'un modèle linéaire
}
\examples{
data(Mesures,package="BioStatR")
Mes.B = subset(Mesures,Mesures$espece=="bignone")
model2<-lm(masse~taille+I(taille^2),data=Mes.B)
my.confidence.region(model2, which=1)
my.confidence.region(model2, which=2)
my.confidence.region(model2, which=3)

}
