% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createMessage.R
\name{createMessage}
\alias{createMessage}
\title{HTML Summary of Model Result}
\usage{
createMessage(ID, path = NULL, outputData)
}
\arguments{
\item{ID}{integer, Model ID value determined from MobileTrigger::ListModels() output
when SelectMDL = NULL}

\item{path}{string, path to the /Models/ folder.}

\item{outputData}{data.frame, table with model, inputs, and outputs.}
}
\value{
A HTML summary for e-mail message response.
}
\description{
Function takes i) a selected model from the TRIGGER_PATH]/Models/ folder
and the results and makes an HTML summary for the e-mail message response.
}
\examples{
\donttest{
################################
# createMessage Example        #
################################

  MDLpath <- 'c:/triggers/Models/'
  InputPath <- 'c:/triggers/modelInput.txt'

# Read Data and Model -----------------------------------------------------
  Input <- MailTriggerInput(InputPath=InputPath)

# Load Selected Model -----------------------------------------------------
  MDL <- GetModel(ID = Input$ID, path = MDLpath)
# Predict -----------------------------------------------------------------
  if(MDL == 'No Models in Path'){
  }else if(!is.null(MDL[[1]]$scaled)){
   if(MDL[[1]]$scaled == T){
     Input$data$Prediction <-
     unlist(predict(MDL[[1]], Input$data)) * MDL[[1]]$outRange + MDL[[1]]$outMin}
   }else{
     Input$data$Prediction <- unlist(predict(MDL[1], Input$data))
  }

# Build Message -----------------------------------------------------------
  msg <- createMessage(ID = Input$ID,
                       path = MDLpath,
                       outputData = Input$data)
}
}
