% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMoTBF.R
\name{MoTBF-Distribution}
\alias{MoTBF-Distribution}
\alias{rMoTBF}
\alias{inversionMethod}
\title{Random generation for MoTBF distributions}
\usage{
rMoTBF(size, fx, domain = NULL)

inversionMethod(size, fx, domain = NULL, data = NULL)
}
\arguments{
\item{size}{A non-negative integer indicating the number of records to generate.}

\item{fx}{An object of class \code{"motbf"}.}

\item{domain}{A \code{"numeric"} vector indicating the lower and upper limits to sample from.
If not specified, the range is taken from the object \code{fx}.}

\item{data}{A \code{"numeric"} vector to be compared with the simulated sample. 
By default, it is \code{NULL}; otherwise, the empirical cumulative distributions of both 
the data and the simulated sample are plotted and the Kolmogorov Smirnov test 
is used to test whether or not both samples can be considered to be drawn from the same distribution.}
}
\value{
\code{rMoTBF()} returns a \code{"numeric"} vector containing the simulated values. 
\code{inversionMethod()} returns a list with the simulated values and the results 
of the two-sample Kolmogorov-Smirnov test, as well as the plot of the CDFs of the 
original and simulated data.
}
\description{
Random generation for mixtures of truncated basis functions defined in a specific domain.
The inverse transform method is used.
}
\examples{

## 1. EXAMPLE
## Data
X <- rnorm(1000, mean = 5, sd = 3)

## Learning
f <- univMoTBF(X, POTENTIAL_TYPE="MOP", nparam=10)
plot(f, xlim = f$Domain)

## Random sample
Y <- rMoTBF(size = 500, fx = f)
ks.test(X,Y)

## Plots
hist(Y, prob = TRUE, add = TRUE)

## 2. EXAMPLE 
## Data
X <- rweibull(5000, shape=2)

## Learning
f <- univMoTBF(X, POTENTIAL_TYPE="MOP", nparam=10)
plot(f, xlim = f$Domain)

## Random sample
inv <- inversionMethod(size = 500, fx = f, data = X)
attributes(inv)
inv$test
Y <- inv$sample 

## Plots
plot(f, xlim = f$Domain)
hist(Y, prob = TRUE, add = TRUE)

}
\seealso{
\link{integralMoTBF}
}
