% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joint.R
\name{marginalJointMoTBF}
\alias{marginalJointMoTBF}
\title{Marginal Joint MoTBF}
\usage{
marginalJointMoTBF(P, var)
}
\arguments{
\item{P}{A joint function of class \code{"jointmotbf"}.}

\item{var}{The \code{"numeric"} position or the \code{"character"} name of the marginal variable.}
}
\value{
The marginal of a \code{"jointmotbf"} function. The result is an object of class \code{"motbf"}.
}
\description{
Computes the marginal functions of a \code{"jointmotbf"}
object.
}
\examples{
## 1. EXAMPLE 
## Dataset with 2 variables
X <- data.frame(rnorm(100), rnorm(100))

## Joint function
dim <- c(4,3)
param <- parametersJointMoTBF(X, dimensions = dim)
P <- jointMoTBF(param)
P

## Marginal
marginalJointMoTBF(P, var = "x")
marginalJointMoTBF(P, var = 2)

##############################################################################
## MORE EXAMPLES #############################################################
##############################################################################
\donttest{
## Generate a dataset with 3 variables
data <- data.frame(rnorm(100), rnorm(100), rnorm(100))

## Joint function
dim <- c(2,1,3)
param <- parametersJointMoTBF(data, dimensions = dim)
P <- jointMoTBF(param)
nVariables(P)

## Marginal
marginalJointMoTBF(P, var="x")
marginalJointMoTBF(P, var="y")
marginalJointMoTBF(P, var="z")
}
}
\seealso{
\link{jointMoTBF} and \link{evalJointFunction}
}
