% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/priorKnowledge.R
\name{generateNormalPriorData}
\alias{generateNormalPriorData}
\title{Prior Data}
\usage{
generateNormalPriorData(graph, data, size, means, deviations = NULL)
}
\arguments{
\item{graph}{A network of the class \code{"bn"}, \code{"graphNEL"} or \code{"network"}.}

\item{data}{A datase of class \code{"data.frame"} containing the continuous variables of the dataset.}

\item{size}{A \code{"numeric"} value indicating the number of records to generate for each variable in the dataset.}

\item{means}{A \code{"numeric"} vector with the averiage of each variable. The names of the vector must be the name
of the variables of which the information is given a priori by the expert.}

\item{deviations}{A \code{"numeric"} vector with the desviations of each variable. The names of the vector must be the name
of the variables of which the information is given a priori by the expert. By default it is \code{NULL} and the desviations
of the given data are taken.}
}
\value{
A normal prior data set of class \code{"data.frame"}.
}
\description{
Generate a prior dataset taking in to account the relationships
between varibles inside a given network.
}
\examples{
## Data
data(ecoli)
data <- ecoli[,-c(1,9)] ## remove sequece.name and class
X <- TrainingandTestData(data, percentage_test = 0.95)
Xtraining <- X$Training
Xtest <- X$Test

## DAG
dag <- LearningHC(data)
plot(dag)

## Means and desviations
colnames(data)

m <- sapply(data, mean)
m <- m[-which(is.na(m))]
names(m)

d <- sapply(data, sd)
d <- d[-which(is.na(m))]
names(d)

## Prior Dataset
n <- 5600
priorData <- generateNormalPriorData(dag, data = Xtraining, size = n, means = m)
summary(priorData)
ncol(priorData)
nrow(priorData)
class(priorData)
}
\seealso{
\link{rnormMultiv}
}

