% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_functions.R
\name{initialize_Y}
\alias{initialize_Y}
\title{Clustering initialization}
\usage{
initialize_Y(dtm, Q, K, init = "random")
}
\arguments{
\item{dtm}{An object of class \code{\link{DocumentTermMatrix}}}

\item{Q}{The number of cluster}

\item{K}{The dimension of the latent space. It is mandatory, for
compatibility reasons but not always used (e.g. random do not use it).}

\item{init}{Either: \itemize{\item \code{'random'}: Random initialization.
\item \code{'kmeans_lda'}: A Q-kmeans on the latent space (theta matrix) of
a K-topic LDA.  \item A user defined function which MUST take the following
structure for compatibility \code{init <- function(dtm, Q, K, nruns, ...)}}}
}
\value{
A vector of size equal to the number of row of \code{dtm}, containing
  a Q-clustering
}
\description{
Perform a \code{DocumentTermMatrix} clustering via default
  routines or allow for user specified function
}
\details{
For more details see \code{\link{benchmarks-functions}}
}
\examples{
\donttest{
simu = simulate_BBC(N = 100, L = 100)
Q = 6
K = 4
Y = initialize_Y(simu$dtm.full, Q, K, init = 'kmeans_lda')
}
}
