% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting_Functions.R
\name{MoE_Similarity}
\alias{MoE_Similarity}
\title{Plot the Similarity Matrix of a MoEClust Mixture Model}
\usage{
MoE_Similarity(res,
               col = grDevices::heat.colors(30L, rev=TRUE), 
               reorder = TRUE, 
               legend = TRUE,
               ...)
}
\arguments{
\item{res}{An object of class \code{"MoEClust"} generated by \code{\link{MoE_clust}}, or an object of class \code{"MoECompare"} generated by \code{\link{MoE_compare}}. Models with a noise component are facilitated here too.}

\item{col}{A vector of colours as per \code{\link[graphics]{image}}. Will be checked for validity.}

\item{reorder}{A logical (defaults to \code{TRUE}) indicating whether observations should be reordered for visual clarity.}

\item{legend}{A logical (defaults to \code{TRUE}) indicating whether to append a colour key legend.}

\item{...}{Catches unused arguments, or arguments to be passed to \code{\link[stats]{hclust}} when \code{reorder=TRUE}.}
}
\value{
The similarity matrix in the form of a heatmap is plotted; the matrix itself can also be returned invisibly. The invisibly returned matrix will also be reordered if \code{reordered=TRUE}.
}
\description{
Produces a heatmap of the similarity matrix constructed from the \code{res$z} matrix at convergence of a MoEClust mixture model.
}
\note{
\code{\link{plot.MoEClust}} is a wrapper to \code{\link{MoE_Similarity}} which accepts the default arguments, and also produces other types of plots.
}
\examples{
data(ais)
mod <- MoE_clust(ais[,3:7], G=2, modelNames="EEE", gating= ~ SSF + Ht,
                 expert= ~ sex, network.data=ais, tau0=0.1, noise.gate=FALSE)
sim <- MoE_Similarity(mod)
}
\seealso{
\code{\link{MoE_clust}}, \code{\link{plot.MoEClust}},
}
\author{
Keefe Murphy - <\email{keefe.murphy@mu.ie}>
}
\keyword{plotting}
