% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_discr_data.R
\name{load_discr_data}
\alias{load_discr_data}
\title{Load trophic discrimination factor (TDF) data}
\usage{
load_discr_data(filename, mix)
}
\arguments{
\item{filename}{csv file with the discrimination data}

\item{mix}{output from \code{\link{load_mix_data}}}
}
\value{
discr, a list including:
\itemize{
 \item \code{discr$mu}, matrix of discrimination means
 \item \code{discr$sig2}, matrix of discrimination variances
}
}
\description{
\code{load_discr_data} loads the trophic discrimination factor (TDF) data.
TDF is the amount that a consumer's tissue biotracer values are modified
(enriched/depleted) \emph{after} consuming a source. If tracers are conservative,
then set TDF = 0 (ex. essential fatty acids, fatty acid profile data,
element concentrations).
}

